/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.google.common.collect.ImmutableSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imapserver.netty.IMAPServer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class IMAPServerConfigurationTest {
    IMAPServerConfigurationTest() {
    }

    @Test
    void getImapConfigurationShouldReturnDefaultValuesWhenEmpty() {
        ImapConfiguration imapConfiguration = IMAPServer.getImapConfiguration((HierarchicalConfiguration)new BaseHierarchicalConfiguration());
        ImapConfiguration expectImapConfiguration = ImapConfiguration.builder().enableIdle(Boolean.valueOf(true)).idleTimeInterval(120L).idleTimeIntervalUnit(ImapConfiguration.DEFAULT_HEARTBEAT_INTERVAL_UNIT).disabledCaps(ImmutableSet.of()).build();
        Assertions.assertThat((Object)imapConfiguration).isEqualTo((Object)expectImapConfiguration);
    }

    @Test
    void getImapConfigurationShouldReturnSetValue() {
        BaseHierarchicalConfiguration configurationBuilder = new BaseHierarchicalConfiguration();
        configurationBuilder.addProperty("enableIdle", (Object)"false");
        configurationBuilder.addProperty("idleTimeInterval", (Object)"1");
        configurationBuilder.addProperty("idleTimeIntervalUnit", (Object)"MINUTES");
        configurationBuilder.addProperty("disabledCaps", (Object)"ACL | MOVE");
        ImapConfiguration imapConfiguration = IMAPServer.getImapConfiguration((HierarchicalConfiguration)configurationBuilder);
        ImapConfiguration expectImapConfiguration = ImapConfiguration.builder().enableIdle(Boolean.valueOf(false)).idleTimeInterval(1L).idleTimeIntervalUnit(TimeUnit.MINUTES).disabledCaps(ImmutableSet.of((Object)"ACL", (Object)"MOVE")).build();
        Assertions.assertThat((Object)imapConfiguration).isEqualTo((Object)expectImapConfiguration);
    }
}

