/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.net.InetSocketAddress;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imapserver.netty.NettyConstants;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class ImapIdleStateHandler
extends IdleStateAwareChannelHandler
implements NettyConstants {
    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) throws Exception {
        if (e.getState().equals((Object)IdleState.ALL_IDLE)) {
            ImapSession session = (ImapSession)attributes.get(ctx.getChannel());
            InetSocketAddress address = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
            session.getLog().info("Logout client " + address.getHostName() + " (" + address.getAddress().getHostAddress() + ") because it idled for too long...");
            session.logout();
            ctx.getChannel().close();
        }
        super.channelIdle(ctx, e);
    }
}

