/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imapserver.netty.IMAPServerMBean;
import org.apache.james.imapserver.netty.ImapChannelUpstreamHandler;
import org.apache.james.imapserver.netty.ImapIdleStateHandler;
import org.apache.james.imapserver.netty.ImapMetrics;
import org.apache.james.imapserver.netty.ImapRequestFrameDecoder;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.imapserver.netty.SwitchableLineDelimiterBasedFrameDecoderFactory;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.netty.ChannelGroupHandler;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.ConnectionLimitUpstreamHandler;
import org.apache.james.protocols.netty.ConnectionPerIpLimitUpstreamHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMAPServer
extends AbstractConfigurableAsyncServer
implements ImapConstants,
IMAPServerMBean,
NettyConstants {
    private static final Logger LOG = LoggerFactory.getLogger(IMAPServer.class);
    private static final String softwaretype = "JAMES IMAP4rev1 Server ";
    private static final String DEFAULT_TIME_UNIT = "SECONDS";
    private static final String CAPABILITY_SEPARATOR = "|";
    private final ImapProcessor processor;
    private final ImapEncoder encoder;
    private final ImapDecoder decoder;
    private final ImapMetrics imapMetrics;
    private String hello;
    private boolean compress;
    private int maxLineLength;
    private int inMemorySizeLimit;
    private boolean plainAuthDisallowed;
    private int timeout;
    private int literalSizeLimit;
    public static final int DEFAULT_MAX_LINE_LENGTH = 65536;
    public static final int DEFAULT_IN_MEMORY_SIZE_LIMIT = 0xA00000;
    public static final int DEFAULT_TIMEOUT = 1800;
    public static final int DEFAULT_LITERAL_SIZE_LIMIT = 0;

    public IMAPServer(ImapDecoder decoder, ImapEncoder encoder, ImapProcessor processor, ImapMetrics imapMetrics) {
        this.processor = processor;
        this.encoder = encoder;
        this.decoder = decoder;
        this.imapMetrics = imapMetrics;
    }

    public void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        this.hello = "JAMES IMAP4rev1 Server  Server " + this.getHelloName() + " is ready.";
        this.compress = configuration.getBoolean("compress", false);
        this.maxLineLength = configuration.getInt("maxLineLength", 65536);
        this.inMemorySizeLimit = configuration.getInt("inMemorySizeLimit", 0xA00000);
        this.literalSizeLimit = configuration.getInt("literalSizeLimit", 0);
        this.plainAuthDisallowed = configuration.getBoolean("plainAuthDisallowed", false);
        this.timeout = configuration.getInt("timeout", 1800);
        if (this.timeout < 1800) {
            throw new ConfigurationException("Minimum timeout of 30 minutes required. See rfc2060 5.4 for details");
        }
        if (this.timeout < 0) {
            this.timeout = 0;
        }
        this.processor.configure(IMAPServer.getImapConfiguration(configuration));
    }

    @VisibleForTesting
    static ImapConfiguration getImapConfiguration(HierarchicalConfiguration configuration) {
        ImmutableSet disabledCaps = ImmutableSet.copyOf((Iterable)Splitter.on((String)CAPABILITY_SEPARATOR).split((CharSequence)configuration.getString("disabledCaps", "")));
        return ImapConfiguration.builder().enableIdle(Boolean.valueOf(configuration.getBoolean("enableIdle", true))).idleTimeInterval(configuration.getLong("idleTimeInterval", 120L)).idleTimeIntervalUnit(IMAPServer.getTimeIntervalUnit(configuration.getString("idleTimeIntervalUnit", DEFAULT_TIME_UNIT))).disabledCaps(disabledCaps).build();
    }

    private static TimeUnit getTimeIntervalUnit(String timeIntervalUnit) {
        try {
            return TimeUnit.valueOf(timeIntervalUnit);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Time interval unit is not valid {}, the default {} value should be used", (Object)timeIntervalUnit, (Object)ImapConfiguration.DEFAULT_HEARTBEAT_INTERVAL_UNIT);
            return ImapConfiguration.DEFAULT_HEARTBEAT_INTERVAL_UNIT;
        }
    }

    public int getDefaultPort() {
        return 143;
    }

    public String getServiceType() {
        return "IMAP Service";
    }

    protected ChannelPipelineFactory createPipelineFactory(final ChannelGroup group) {
        return new ChannelPipelineFactory(){
            private final ChannelGroupHandler groupHandler;
            private final HashedWheelTimer timer;
            private final TimeUnit TIMEOUT_UNIT;
            {
                this.groupHandler = new ChannelGroupHandler(group);
                this.timer = new HashedWheelTimer();
                this.TIMEOUT_UNIT = TimeUnit.SECONDS;
            }

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("groupHandler", (ChannelHandler)this.groupHandler);
                pipeline.addLast("idleHandler", (ChannelHandler)new IdleStateHandler((Timer)this.timer, 0L, 0L, (long)IMAPServer.this.timeout, this.TIMEOUT_UNIT));
                pipeline.addLast("timeoutHandler", (ChannelHandler)new ImapIdleStateHandler());
                pipeline.addLast("connectionLimitHandler", (ChannelHandler)new ConnectionLimitUpstreamHandler(IMAPServer.this.connectionLimit));
                pipeline.addLast("connectionPerIpLimitHandler", (ChannelHandler)new ConnectionPerIpLimitUpstreamHandler(IMAPServer.this.connPerIP));
                pipeline.addLast("framer", IMAPServer.this.getFrameHandlerFactory().create(pipeline));
                Encryption secure = IMAPServer.this.getEncryption();
                if (secure != null && !secure.isStartTLS()) {
                    SSLEngine engine = secure.getContext().createSSLEngine();
                    engine.setUseClientMode(false);
                    pipeline.addFirst("sslHandler", (ChannelHandler)new SslHandler(engine));
                }
                pipeline.addLast("connectionCountHandler", (ChannelHandler)IMAPServer.this.getConnectionCountHandler());
                pipeline.addLast("chunkWriteHandler", (ChannelHandler)new ChunkedWriteHandler());
                ExecutionHandler ehandler = IMAPServer.this.getExecutionHandler();
                if (ehandler != null) {
                    pipeline.addLast("executionHandler", (ChannelHandler)ehandler);
                }
                pipeline.addLast("requestDecoder", (ChannelHandler)new ImapRequestFrameDecoder(IMAPServer.this.decoder, IMAPServer.this.inMemorySizeLimit, IMAPServer.this.literalSizeLimit));
                pipeline.addLast("coreHandler", (ChannelHandler)IMAPServer.this.createCoreHandler());
                return pipeline;
            }
        };
    }

    protected String getDefaultJMXName() {
        return "imapserver";
    }

    protected ChannelUpstreamHandler createCoreHandler() {
        Encryption secure = this.getEncryption();
        ImapChannelUpstreamHandler coreHandler = secure != null && secure.isStartTLS() ? new ImapChannelUpstreamHandler(this.hello, this.processor, this.encoder, this.getLogger(), this.compress, this.plainAuthDisallowed, secure.getContext(), this.getEnabledCipherSuites(), this.imapMetrics) : new ImapChannelUpstreamHandler(this.hello, this.processor, this.encoder, this.getLogger(), this.compress, this.plainAuthDisallowed, this.imapMetrics);
        return coreHandler;
    }

    protected OneToOneEncoder createEncoder() {
        return null;
    }

    protected ChannelHandlerFactory createFrameHandlerFactory() {
        return new SwitchableLineDelimiterBasedFrameDecoderFactory(this.maxLineLength);
    }
}

