/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.stream.BlockingChannelBufferInputStream;
import org.jboss.netty.handler.stream.ChannelOutputStream;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.jboss.netty.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamHandler
extends ReadTimeoutHandler {
    private final ExecutorService executor;
    private static final String KEY_IN = "stream.in";
    private static final String KEY_OUT = "stream.out";

    public StreamHandler(Timer timer, int readerIdleTimeSeconds) {
        this(timer, readerIdleTimeSeconds, Executors.newCachedThreadPool());
    }

    public StreamHandler(Timer timer, long readerIdleTime, TimeUnit unit) {
        this(timer, readerIdleTime, unit, Executors.newCachedThreadPool());
    }

    public StreamHandler(Timer timer, int readerIdleTimeSeconds, ExecutorService executor) {
        super(timer, readerIdleTimeSeconds);
        this.executor = executor;
    }

    public StreamHandler(Timer timer, long readerIdleTime, TimeUnit unit, ExecutorService executor) {
        super(timer, readerIdleTime, unit);
        this.executor = executor;
    }

    protected abstract void processStreamIo(ChannelHandlerContext var1, InputStream var2, OutputStream var3);

    public void channelConnected(final ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        final BlockingChannelBufferInputStream in = new BlockingChannelBufferInputStream();
        final ChannelOutputStream out = new ChannelOutputStream(ctx.getChannel());
        Map<Object, Object> attachment = this.getAttachment(ctx);
        attachment.put(KEY_IN, in);
        attachment.put(KEY_OUT, out);
        this.executor.execute(new Runnable(){

            public void run() {
                StreamHandler.this.processStreamIo(ctx, in, out);
            }
        });
        ctx.setAttachment(attachment);
        super.channelConnected(ctx, e);
    }

    protected final Map<Object, Object> getAttachment(ChannelHandlerContext ctx) {
        HashMap attachment = (HashMap)ctx.getAttachment();
        if (attachment == null) {
            attachment = new HashMap();
            ctx.setAttachment(attachment);
        }
        return attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Map<Object, Object> attachment = this.getAttachment(ctx);
        InputStream in = (InputStream)attachment.get(KEY_IN);
        OutputStream out = (OutputStream)attachment.get(KEY_OUT);
        try {
            in.close();
        }
        finally {
            out.close();
        }
        super.channelClosed(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        BlockingChannelBufferInputStream in = (BlockingChannelBufferInputStream)this.getAttachment(ctx).get(KEY_IN);
        in.write((ChannelBuffer)e.getMessage());
        super.messageReceived(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        BlockingChannelBufferInputStream in = (BlockingChannelBufferInputStream)this.getAttachment(ctx).get(KEY_IN);
        IOException ex = null;
        if (e.getCause() instanceof ReadTimeOutException) {
            ex = (IOException)e.getCause().getCause();
        } else if (e.getCause() instanceof IOException) {
            ex = (IOException)e.getCause();
        }
        if (e != null && in != null) {
            in.throwException(ex);
        } else {
            ctx.getChannel().close();
        }
    }

    protected void readTimedOut(ChannelHandlerContext ctx) throws Exception {
        throw new ReadTimeOutException(new SocketTimeoutException("Read timeout"));
    }

    private static class ReadTimeOutException
    extends RuntimeException {
        private static final long serialVersionUID = 3976736960742503222L;

        public ReadTimeOutException(IOException cause) {
            super(cause);
        }
    }
}

