/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;

public class ChannelOutputStream
extends OutputStream {
    private final Channel channel;
    private ChannelFuture lastChannelFuture;

    public ChannelOutputStream(Channel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.channel.close().awaitUninterruptibly();
        }
    }

    private void checkClosed() throws IOException {
        if (!this.channel.isConnected()) {
            throw new IOException("The session has been closed.");
        }
    }

    private synchronized void write(ChannelBuffer buf) throws IOException {
        ChannelFuture future;
        this.checkClosed();
        this.lastChannelFuture = future = this.channel.write((Object)buf);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ChannelBuffers.copiedBuffer((byte[])((byte[])b.clone()), (int)off, (int)len));
    }

    public void write(int b) throws IOException {
        ChannelBuffer buf = ChannelBuffers.buffer((int)1);
        buf.writeByte((int)((byte)b));
        this.write(buf);
    }

    public synchronized void flush() throws IOException {
        if (this.lastChannelFuture == null) {
            return;
        }
        this.lastChannelFuture.awaitUninterruptibly();
        if (!this.lastChannelFuture.isSuccess()) {
            throw new IOException("The bytes could not be written to the session");
        }
    }

    public Channel getChannel() {
        return this.channel;
    }
}

