/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.stream;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class BlockingChannelBufferInputStream
extends InputStream {
    private final Object mutex = new Object();
    private final ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
    private volatile boolean closed;
    private volatile boolean released;
    private IOException exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        if (this.released) {
            return 0;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.buf.readableBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.closed = true;
            this.releaseBuffer();
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.waitForData()) {
                return -1;
            }
            return this.buf.readByte() & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.waitForData()) {
                return -1;
            }
            int readBytes = len > this.buf.readableBytes() ? this.buf.readableBytes() : len;
            this.buf.readBytes(b, off, readBytes);
            return readBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForData() throws IOException {
        if (this.released) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            while (!this.released && this.buf.readableBytes() == 0 && this.exception == null) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException e) {
                    IOException ioe = new IOException("Interrupted while waiting for more data");
                    ioe.initCause(e);
                    throw ioe;
                }
            }
        }
        if (this.exception != null) {
            this.releaseBuffer();
            throw this.exception;
        }
        if (this.closed && this.buf.readableBytes() == 0) {
            this.releaseBuffer();
            return false;
        }
        return true;
    }

    private void releaseBuffer() {
        if (this.released) {
            return;
        }
        this.released = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelBuffer src) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.buf.readable()) {
                this.buf.writeBytes(src);
            } else {
                this.buf.clear();
                this.buf.writeBytes(src);
                this.buf.readerIndex(0);
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwException(IOException e) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.exception == null) {
                this.exception = e;
                this.mutex.notifyAll();
            }
        }
    }
}

