/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.socket.netty;

import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.logging.Log;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.lifecycle.Configurable;
import org.apache.james.lifecycle.LogEnabled;
import org.apache.james.protocols.impl.AbstractAsyncServer;
import org.apache.james.services.FileSystem;
import org.apache.james.socket.ServerMBean;

public abstract class AbstractConfigurableAsyncServer
extends AbstractAsyncServer
implements LogEnabled,
Configurable,
ServerMBean {
    private static final int DEFAULT_BACKLOG = 200;
    private static final int DEFAULT_TIMEOUT = 300;
    private static final String TIMEOUT_NAME = "connectiontimeout";
    private static final String BACKLOG_NAME = "connectionBacklog";
    public static final String HELLO_NAME = "helloName";
    private FileSystem fileSystem;
    private Log logger;
    private DNSService dns;
    private boolean enabled;
    protected int connPerIP;
    private boolean useStartTLS;
    private boolean useSSL;
    protected int connectionLimit;
    private String helloName;
    private String keystore;
    private String secret;
    private SSLContext context;

    @Resource(name="dnsservice")
    public final void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    @Resource(name="filesystem")
    public final void setFileSystem(FileSystem filesystem) {
        this.fileSystem = filesystem;
    }

    public final void setLog(Log logger) {
        this.logger = logger;
    }

    public final void configure(HierarchicalConfiguration config) throws ConfigurationException {
        String connectionLimitPerIP;
        StringBuilder infoBuffer;
        SubnodeConfiguration handlerConfiguration = config.configurationAt("handler");
        this.enabled = config.getBoolean("[@enabled]", true);
        Log logger = this.getLogger();
        if (!this.enabled) {
            logger.info((Object)(this.getServiceType() + " disabled by configuration"));
            return;
        }
        this.setPort(config.getInt("port", this.getDefaultPort()));
        try {
            String bindAddress = config.getString("bind", null);
            if (null != bindAddress) {
                String bindTo = InetAddress.getByName(bindAddress).getHostName();
                infoBuffer = new StringBuilder(64).append(this.getServiceType()).append(" bound to: ").append(bindTo);
                logger.info((Object)infoBuffer.toString());
                this.setIP(bindTo);
            }
        }
        catch (UnknownHostException unhe) {
            throw new ConfigurationException("Malformed bind parameter in configuration of service " + this.getServiceType(), (Throwable)unhe);
        }
        this.configureHelloName((Configuration)handlerConfiguration);
        this.setTimeout(handlerConfiguration.getInt(TIMEOUT_NAME, 300));
        infoBuffer = new StringBuilder(64).append(this.getServiceType()).append(" handler connection timeout is: ").append(this.getTimeout());
        logger.info((Object)infoBuffer.toString());
        this.setBacklog(config.getInt(BACKLOG_NAME, 200));
        infoBuffer = new StringBuilder(64).append(this.getServiceType()).append(" connection backlog is: ").append(this.getBacklog());
        logger.info((Object)infoBuffer.toString());
        String connectionLimitString = config.getString("connectionLimit", null);
        if (connectionLimitString != null) {
            try {
                this.connectionLimit = new Integer(connectionLimitString);
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)"Connection limit value is not properly formatted.", (Throwable)nfe);
            }
            if (this.connectionLimit < 0) {
                logger.error((Object)"Connection limit value cannot be less than zero.");
                throw new ConfigurationException("Connection limit value cannot be less than zero.");
            }
            if (this.connectionLimit > 0) {
                infoBuffer = new StringBuilder(128).append(this.getServiceType()).append(" will allow a maximum of ").append(connectionLimitString).append(" connections.");
                logger.info((Object)infoBuffer.toString());
            }
        }
        if ((connectionLimitPerIP = handlerConfiguration.getString("connectionLimitPerIP", null)) != null) {
            try {
                this.connPerIP = new Integer(connectionLimitPerIP);
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)"Connection limit per IP value is not properly formatted.", (Throwable)nfe);
            }
            if (this.connPerIP < 0) {
                logger.error((Object)"Connection limit per IP value cannot be less than zero.");
                throw new ConfigurationException("Connection limit value cannot be less than zero.");
            }
            if (this.connPerIP > 0) {
                infoBuffer = new StringBuilder(128).append(this.getServiceType()).append(" will allow a maximum of ").append(this.connPerIP).append(" per IP connections for " + this.getServiceType());
                logger.info((Object)infoBuffer.toString());
            }
        }
        this.useStartTLS = config.getBoolean("tls.[@startTLS]", false);
        this.useSSL = config.getBoolean("tls.[@socketTLS]", false);
        if (this.useSSL && this.useStartTLS) {
            throw new ConfigurationException("startTLS is only supported when using plain sockets");
        }
        if (this.useStartTLS || this.useSSL) {
            this.keystore = config.getString("tls.keystore", null);
            if (this.keystore == null) {
                throw new ConfigurationException("keystore needs to get configured");
            }
            this.secret = config.getString("tls.secret", "");
        }
        this.doConfigure(config);
    }

    @PostConstruct
    public final void init() throws Exception {
        if (this.isEnabled()) {
            this.preInit();
            this.buildSSLContext();
            this.start();
        }
    }

    @PreDestroy
    public final void destroy() {
        this.getLogger().info((Object)("Dispose " + this.getServiceType()));
        if (this.isEnabled()) {
            this.stop();
        }
    }

    protected void preInit() throws Exception {
    }

    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
    }

    protected DNSService getDNSService() {
        return this.dns;
    }

    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected void configureHelloName(Configuration handlerConfiguration) {
        String hostName = null;
        try {
            hostName = this.dns.getHostName(this.dns.getLocalHost());
        }
        catch (UnknownHostException ue) {
            hostName = "localhost";
        }
        StringBuilder infoBuffer = new StringBuilder(64).append(this.getServiceType()).append(" is running on: ").append(hostName);
        this.getLogger().info((Object)infoBuffer.toString());
        boolean autodetect = handlerConfiguration.getBoolean("helloName.[@autodetect]", true);
        this.helloName = autodetect ? hostName : handlerConfiguration.getString("helloName.localhost");
        infoBuffer = new StringBuilder(64).append(this.getServiceType()).append(" handler hello name is: ").append(this.helloName);
        this.getLogger().info((Object)infoBuffer.toString());
    }

    protected Log getLogger() {
        return this.logger;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHelloName() {
        return this.helloName;
    }

    protected boolean isStartTLSSupported() {
        return this.useStartTLS;
    }

    protected boolean isSSLSocket() {
        return this.useSSL;
    }

    private void buildSSLContext() throws Exception {
        if (this.useStartTLS || this.useSSL) {
            String algorithm = "SunX509";
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(this.fileSystem.getFile(this.keystore)), this.secret.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, this.secret.toCharArray());
            this.context = SSLContext.getInstance("TLS");
            this.context.init(kmf.getKeyManagers(), null, null);
        }
    }

    protected abstract int getDefaultPort();

    protected SSLContext getSSLContext() {
        return this.context;
    }

    public String getSocketType() {
        if (this.isSSLSocket()) {
            return "secure";
        }
        return "plain";
    }

    public boolean getStartTLSSupported() {
        return this.isStartTLSSupported();
    }

    public int getMaximumConcurrentConnections() {
        return this.connectionLimit;
    }
}

