/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.socket;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.logging.Log;
import org.apache.james.lifecycle.Configurable;
import org.apache.james.lifecycle.LogEnabled;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.HandlersPackage;
import org.apache.james.protocols.api.ProtocolHandlerChain;
import org.apache.james.protocols.api.WiringException;
import org.apache.james.services.InstanceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamesProtocolHandlerChain
implements ProtocolHandlerChain,
Configurable,
LogEnabled {
    private Log log;
    private String coreHandlersPackage;
    private LinkedList handlers = new LinkedList();
    private HierarchicalConfiguration config;
    private InstanceFactory factory;

    public void setCoreHandlersPackage(String coreHandlersPackage) {
        this.coreHandlersPackage = coreHandlersPackage;
    }

    @Resource(name="instanceFactory")
    public void setInstanceFactory(InstanceFactory factory) {
        this.factory = factory;
    }

    @PostConstruct
    public void init() throws Exception {
        SubnodeConfiguration handlerchainConfig = this.config.configurationAt("handler.handlerchain");
        if (handlerchainConfig.getString("[@coreHandlersPackage]") == null) {
            handlerchainConfig.addProperty("[@coreHandlersPackage]", (Object)this.coreHandlersPackage);
        }
        this.loadHandlers((HierarchicalConfiguration)handlerchainConfig);
        this.wireExtensibleHandlers();
    }

    private void wireExtensibleHandlers() throws WiringException {
        for (int a = 0; a < this.handlers.size(); ++a) {
            Object obj = this.handlers.get(a);
            if (!(obj instanceof ExtensibleHandler)) continue;
            ExtensibleHandler extensibleHandler = (ExtensibleHandler)obj;
            List markerInterfaces = extensibleHandler.getMarkerInterfaces();
            for (int i = 0; i < markerInterfaces.size(); ++i) {
                Class markerInterface = (Class)markerInterfaces.get(i);
                LinkedList extensions = this.getHandlers(markerInterface);
                extensibleHandler.wireExtensions(markerInterface, extensions);
            }
        }
    }

    private void loadClass(String className, HierarchicalConfiguration config) throws Exception {
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        Object obj = this.factory.newInstance(clazz, this.log, config);
        if (obj instanceof HandlersPackage) {
            List c = ((HandlersPackage)obj).getHandlers();
            for (String cName : c) {
                HierarchicalConfiguration cmdConf = this.addHandler(cName);
                this.loadClass(cName, cmdConf);
            }
        } else {
            this.handlers.add(obj);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Added Handler: " + className));
            }
        }
    }

    private HierarchicalConfiguration addHandler(String className) throws ConfigurationException {
        DefaultConfigurationBuilder hConf = new DefaultConfigurationBuilder();
        hConf.addProperty("handler.[@class]", (Object)className);
        return hConf;
    }

    public <T> LinkedList<T> getHandlers(Class<T> type) {
        LinkedList classHandlers = new LinkedList();
        for (Object obj : this.handlers) {
            if (!type.isInstance(obj)) continue;
            classHandlers.add(obj);
        }
        return classHandlers;
    }

    private void loadHandlers(HierarchicalConfiguration commonsConf) throws Exception {
        List children = commonsConf.configurationsAt("handler");
        String coreCmdName = commonsConf.getString("[@coreHandlersPackage]");
        this.loadClass(coreCmdName, this.addHandler(coreCmdName));
        if (children != null && !children.isEmpty()) {
            for (int i = 0; i < children.size(); ++i) {
                HierarchicalConfiguration hConf = (HierarchicalConfiguration)children.get(i);
                String className = hConf.getString("[@class]");
                if (className == null || className.equals(coreCmdName)) continue;
                this.loadClass(className, hConf);
            }
        }
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.config = config;
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

