/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.amqp;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.jayway.awaitility.Awaitility;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.james.util.streams.SwarmGenericContainer;
import org.junit.rules.ExternalResource;

public class AmqpRule
extends ExternalResource {
    private final SwarmGenericContainer rabbitMqContainer;
    private final String exchangeName;
    private final String routingKey;
    private Channel channel;
    private String queueName;
    private Connection connection;
    private String amqpUri;

    public AmqpRule(SwarmGenericContainer rabbitMqContainer, String exchangeName, String routingKey) {
        this.rabbitMqContainer = rabbitMqContainer;
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
    }

    protected void before() throws Throwable {
        this.amqpUri = "amqp://" + this.rabbitMqContainer.getIp();
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUri(this.amqpUri);
        this.waitingForRabbitToBeReady(factory);
        this.connection = factory.newConnection();
        this.channel = this.connection.createChannel();
        this.channel.exchangeDeclare(this.exchangeName, BuiltinExchangeType.DIRECT);
        this.queueName = this.channel.queueDeclare().getQueue();
        this.channel.queueBind(this.queueName, this.exchangeName, this.routingKey);
    }

    public String getAmqpUri() {
        return this.amqpUri;
    }

    public Optional<String> readContent() throws IOException {
        return this.readContentAsBytes().map(value -> new String((byte[])value, Charsets.UTF_8));
    }

    public Optional<byte[]> readContentAsBytes() throws IOException {
        boolean autoAck = true;
        return Optional.ofNullable(this.channel.basicGet(this.queueName, autoAck)).map(GetResponse::getBody);
    }

    protected void after() {
        try {
            this.channel.close();
            this.connection.close();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void waitingForRabbitToBeReady(ConnectionFactory factory) {
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).with().pollInterval(10L, TimeUnit.MILLISECONDS).until(() -> this.isReady(factory));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isReady(ConnectionFactory factory) {
        try (Connection connection = factory.newConnection();){
            boolean bl = true;
            return bl;
        }
        catch (IOException | TimeoutException e) {
            return false;
        }
    }
}

