/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.inject.Module;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionFactory;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.james.mailets.TemporaryJamesServer;
import org.apache.james.mailets.configuration.CommonProcessors;
import org.apache.james.mailets.configuration.MailetConfiguration;
import org.apache.james.mailets.configuration.MailetContainer;
import org.apache.james.mailets.configuration.ProcessorConfiguration;
import org.apache.james.mailets.utils.SMTPMessageSender;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.IMAPMessageReader;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.MimeMessageBuilder;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StripAttachmentTest {
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int IMAP_PORT = 1143;
    private static final int SMTP_PORT = 1025;
    private static final String PASSWORD = "secret";
    private static final String JAMES_APACHE_ORG = "james.org";
    private static final String FROM = "fromUser@james.org";
    private static final String RECIPIENT = "touser@james.org";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private TemporaryJamesServer jamesServer;
    private ConditionFactory calmlyAwait;

    @Before
    public void setup() throws Exception {
        MailetContainer mailetContainer = MailetContainer.builder().postmaster("postmaster@james.org").threads(5).addProcessor(CommonProcessors.root()).addProcessor(CommonProcessors.error()).addProcessor(ProcessorConfiguration.builder().state("transport").enableJmx(true).addMailet(MailetConfiguration.builder().match("All").clazz("RemoveMimeHeader").addProperty("name", "bcc").build()).addMailet(MailetConfiguration.builder().match("All").clazz("StripAttachment").addProperty("attribute", "my.attribute").addProperty("remove", "all").addProperty("notpattern", ".*.tmp.*").build()).addMailet(MailetConfiguration.builder().match("All").clazz("OnlyText").build()).addMailet(MailetConfiguration.builder().match("All").clazz("RecoverAttachment").addProperty("attribute", "my.attribute").build()).addMailet(MailetConfiguration.builder().match("RecipientIsLocal").clazz("org.apache.james.jmap.mailet.VacationMailet").build()).addMailet(MailetConfiguration.builder().match("RecipientIsLocal").clazz("LocalDelivery").build()).build()).build();
        this.jamesServer = new TemporaryJamesServer(this.temporaryFolder, mailetContainer, new Module[0]);
        Duration slowPacedPollInterval = Duration.FIVE_HUNDRED_MILLISECONDS;
        this.calmlyAwait = Awaitility.with().pollInterval(slowPacedPollInterval).and().with().pollDelay(slowPacedPollInterval).await();
        DataProbe dataProbe = (DataProbe)this.jamesServer.getProbe(DataProbeImpl.class);
        dataProbe.addDomain(JAMES_APACHE_ORG);
        dataProbe.addUser(FROM, PASSWORD);
        dataProbe.addUser(RECIPIENT, PASSWORD);
        this.jamesServer.getProbe(MailboxProbeImpl.class).createMailbox("#private", RECIPIENT, "INBOX");
    }

    @After
    public void tearDown() {
        this.jamesServer.shutdown();
    }

    @Test
    public void stripAttachmentShouldPutAttachmentsInMailAttributeWhenConfiguredForIt() throws Exception {
        MimeMessage message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new BodyPart[]{MimeMessageBuilder.bodyPartBuilder().data("simple text").build(), MimeMessageBuilder.bodyPartBuilder().data("Not matching attachment").filename("not_matching.tmp").disposition("attachment").build(), MimeMessageBuilder.bodyPartBuilder().data("Matching attachment").filename("temp.zip").disposition("attachment").build()}).setSubject("test").build();
        FakeMail mail = FakeMail.builder().mimeMessage(message).sender(new MailAddress(FROM)).recipient(new MailAddress(RECIPIENT)).build();
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage((Mail)mail);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
            String processedMessage = imapMessageReader.readFirstMessageInInbox(RECIPIENT, PASSWORD);
            Assertions.assertThat((String)processedMessage).contains(new CharSequence[]{"Matching attachment"});
        }
    }
}

