/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionFactory;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.james.mailets.TemporaryJamesServer;
import org.apache.james.mailets.configuration.CommonProcessors;
import org.apache.james.mailets.configuration.MailetConfiguration;
import org.apache.james.mailets.configuration.MailetContainer;
import org.apache.james.mailets.configuration.ProcessorConfiguration;
import org.apache.james.mailets.utils.SMTPMessageSender;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.transport.mailets.amqp.AmqpRule;
import org.apache.james.util.streams.SwarmGenericContainer;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.IMAPMessageReader;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.MimeMessageBuilder;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class ICSAttachmentWorkflowTest {
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int IMAP_PORT = 1143;
    private static final int SMTP_PORT = 1025;
    private static final String PASSWORD = "secret";
    private static final String JAMES_APACHE_ORG = "james.org";
    private static final String FROM = "fromUser@james.org";
    private static final String RECIPIENT = "touser@james.org";
    private static final String MAIL_ATTRIBUTE = "ical.attachments";
    private static final String PARSED_ICAL_MAIL_ATTRIBUTE = "ical.parsed";
    private static final String JSON_MAIL_ATTRIBUTE = "ical.json";
    private static final String EXCHANGE_NAME = "myExchange";
    private static final String ROUTING_KEY = "myRoutingKey";
    private static final String ICS_UID = "f1514f44bf39311568d640727cff54e819573448d09d2e5677987ff29caa01a9e047feb2aab16e43439a608f28671ab7c10e754ce92be513f8e04ae9ff15e65a9819cf285a6962bc";
    private static final String ICS_DTSTAMP = "20170106T115036Z";
    private static final String ICS_SEQUENCE = "0";
    private static final String ICS_METHOD = "REQUEST";
    private static final String ICS_1 = "BEGIN:VCALENDAR\r\nPRODID:-//Aliasource Groupe LINAGORA//OBM Calendar 3.2.1-rc2//FR\r\nCALSCALE:GREGORIAN\r\nX-OBM-TIME:1483703436\r\nVERSION:2.0\r\nMETHOD:REQUEST\r\nBEGIN:VEVENT\r\nCREATED:20170106T115035Z\r\nLAST-MODIFIED:20170106T115036Z\r\nDTSTAMP:20170106T115036Z\r\nDTSTART:20170111T090000Z\r\nDURATION:PT1H30M\r\nTRANSP:OPAQUE\r\nSEQUENCE:0\r\nSUMMARY:Sprint planning #23\r\nDESCRIPTION:\r\nCLASS:PUBLIC\r\nPRIORITY:5\r\nORGANIZER;X-OBM-ID=128;CN=Raphael OUAZANA:MAILTO:ouazana@linagora.com\r\nX-OBM-DOMAIN:linagora.com\r\nX-OBM-DOMAIN-UUID:02874f7c-d10e-102f-acda-0015176f7922\r\nLOCATION:Hangout\r\nCATEGORIES:\r\nX-OBM-COLOR:\r\nUID:f1514f44bf39311568d640727cff54e819573448d09d2e5677987ff29caa01a9e047feb2aab16e43439a608f28671ab7c10e754ce92be513f8e04ae9ff15e65a9819cf285a6962bc\r\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Matthieu EXT_BAECHLER;PARTSTAT=NEEDS-ACTION;X-OBM-ID=302:MAILTO:baechler@linagora.com\r\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Laura ROYET;PARTSTAT=NEEDS-ACTION;X-OBM-ID=723:MAILTO:royet@linagora.com\r\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Raphael OUAZANA;PARTSTAT=ACCEPTED;X-OBM-ID=128:MAILTO:ouazana@linagora.com\r\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Luc DUZAN;PARTSTAT=NEEDS-ACTION;X-OBM-ID=715:MAILTO:duzan@linagora.com\r\nATTENDEE;CUTYPE=RESOURCE;CN=Salle de reunion Lyon;PARTSTAT=ACCEPTED;X-OBM-ID=66:MAILTO:noreply@linagora.com\r\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Antoine DUPRAT;PARTSTAT=NEEDS-ACTION;X-OBM-ID=453:MAILTO:duprat@linagora.com\r\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Benoit TELLIER;PARTSTAT=NEEDS-ACTION;X-OBM-ID=623:MAILTO:tellier@linagora.com\r\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Quynh Quynh N NGUYEN;PARTSTAT=NEEDS-ACTION;X-OBM-ID=769:MAILTO:nguyen@linagora.com\r\nEND:VEVENT\r\nEND:VCALENDAR\r\n";
    private static final String ICS_2 = "BEGIN:VCALENDAR\nPRODID:-//Aliasource Groupe LINAGORA//OBM Calendar 3.2.1-rc2//FR\nCALSCALE:GREGORIAN\nX-OBM-TIME:1483703436\nVERSION:2.0\nMETHOD:REQUEST\nBEGIN:VEVENT\nCREATED:20170106T115035Z\nLAST-MODIFIED:20170106T115036Z\nDTSTAMP:20170106T115037Z\nDTSTART:20170111T090000Z\nDURATION:PT1H30M\nTRANSP:OPAQUE\nSEQUENCE:1\nSUMMARY:Sprint planning #23\nDESCRIPTION:\nCLASS:PUBLIC\nPRIORITY:5\nORGANIZER;X-OBM-ID=128;CN=Raphael OUAZANA:MAILTO:ouazana@linagora.com\nX-OBM-DOMAIN:linagora.com\nX-OBM-DOMAIN-UUID:02874f7c-d10e-102f-acda-0015176f7922\nLOCATION:Hangout\nCATEGORIES:\nX-OBM-COLOR:\nUID:f1514f44bf39311568d640727cff54e819573448d09d2e5677987ff29caa01a9e047fe\n b2aab16e43439a608f28671ab7c10e754ce92be513f8e04ae9ff15e65a9819cf285a6962bd\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Matthieu EXT_BAECHLER;PARTSTAT=NEE\n DS-ACTION;X-OBM-ID=302:MAILTO:baechler@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Laura ROYET;PARTSTAT=NEEDS-ACTION;\n X-OBM-ID=723:MAILTO:royet@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Raphael OUAZANA;PARTSTAT=ACCEPTED;\n X-OBM-ID=128:MAILTO:ouazana@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Luc DUZAN;PARTSTAT=NEEDS-ACTION;X-\n OBM-ID=715:MAILTO:duzan@linagora.com\nATTENDEE;CUTYPE=RESOURCE;CN=Salle de reunion Lyon;PARTSTAT=ACCEPTED;X-OBM-\n ID=66:MAILTO:noreply@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Antoine DUPRAT;PARTSTAT=NEEDS-ACTI\n ON;X-OBM-ID=453:MAILTO:duprat@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Beno\u00eet TELLIER;PARTSTAT=NEEDS-ACTI\n ON;X-OBM-ID=623:MAILTO:tellier@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Quynh Quynh N NGUYEN;PARTSTAT=NEED\n S-ACTION;X-OBM-ID=769:MAILTO:nguyen@linagora.com\nEND:VEVENT\nEND:VCALENDAR\n";
    private static final String ICS_3 = "BEGIN:VCALENDAR\nPRODID:-//Aliasource Groupe LINAGORA//OBM Calendar 3.2.1-rc2//FR\nCALSCALE:GREGORIAN\nX-OBM-TIME:1483703436\nVERSION:2.0\nMETHOD:REQUEST\nBEGIN:VEVENT\nCREATED:20170106T115035Z\nLAST-MODIFIED:20170106T115036Z\nDTSTAMP:20170106T115038Z\nDTSTART:20170111T090000Z\nDURATION:PT1H30M\nTRANSP:OPAQUE\nSEQUENCE:2\nSUMMARY:Sprint planning #23\nDESCRIPTION:\nCLASS:PUBLIC\nPRIORITY:5\nORGANIZER;X-OBM-ID=128;CN=Raphael OUAZANA:MAILTO:ouazana@linagora.com\nX-OBM-DOMAIN:linagora.com\nX-OBM-DOMAIN-UUID:02874f7c-d10e-102f-acda-0015176f7922\nLOCATION:Hangout\nCATEGORIES:\nX-OBM-COLOR:\nUID:f1514f44bf39311568d640727cff54e819573448d09d2e5677987ff29caa01a9e047fe\n b2aab16e43439a608f28671ab7c10e754ce92be513f8e04ae9ff15e65a9819cf285a6962be\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Matthieu EXT_BAECHLER;PARTSTAT=NEE\n DS-ACTION;X-OBM-ID=302:MAILTO:baechler@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Laura ROYET;PARTSTAT=NEEDS-ACTION;\n X-OBM-ID=723:MAILTO:royet@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Raphael OUAZANA;PARTSTAT=ACCEPTED;\n X-OBM-ID=128:MAILTO:ouazana@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Luc DUZAN;PARTSTAT=NEEDS-ACTION;X-\n OBM-ID=715:MAILTO:duzan@linagora.com\nATTENDEE;CUTYPE=RESOURCE;CN=Salle de reunion Lyon;PARTSTAT=ACCEPTED;X-OBM-\n ID=66:MAILTO:noreply@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Antoine DUPRAT;PARTSTAT=NEEDS-ACTI\n ON;X-OBM-ID=453:MAILTO:duprat@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Beno\u00eet TELLIER;PARTSTAT=NEEDS-ACTI\n ON;X-OBM-ID=623:MAILTO:tellier@linagora.com\nATTENDEE;CUTYPE=INDIVIDUAL;RSVP=TRUE;CN=Quynh Quynh N NGUYEN;PARTSTAT=NEED\n S-ACTION;X-OBM-ID=769:MAILTO:nguyen@linagora.com\nEND:VEVENT\nEND:VCALENDAR\n";
    private static final String ICS_BASE64 = "Content-Type: application/ics;\n name=\"invite.ics\"\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n filename=\"invite.ics\"\n\nQkVHSU46VkNBTEVOREFSDQpQUk9ESUQ6LS8vR29vZ2xlIEluYy8vR29vZ2xlIENhbGVuZGFy\nIDcwLjkwNTQvL0VODQpWRVJTSU9OOjIuMA0KQ0FMU0NBTEU6R1JFR09SSUFODQpNRVRIT0Q6\nUkVRVUVTVA0KQkVHSU46VkVWRU5UDQpEVFNUQVJUOjIwMTcwMTIwVDEzMDAwMFoNCkRURU5E\nOjIwMTcwMTIwVDE0MDAwMFoNCkRUU1RBTVA6MjAxNzAxMTlUMTkxODIzWg0KT1JHQU5JWkVS\nO0NOPUFudG9pbmUgRHVwcmF0Om1haWx0bzphbnRkdXByYXRAZ21haWwuY29tDQpVSUQ6YWg4\nNms1bTM0MmJtY3JiZTlraGtraGxuMDBAZ29vZ2xlLmNvbQ0KQVRURU5ERUU7Q1VUWVBFPUlO\nRElWSURVQUw7Uk9MRT1SRVEtUEFSVElDSVBBTlQ7UEFSVFNUQVQ9TkVFRFMtQUNUSU9OO1JT\nVlA9DQogVFJVRTtDTj1hZHVwcmF0QGxpbmFnb3JhLmNvbTtYLU5VTS1HVUVTVFM9MDptYWls\ndG86YWR1cHJhdEBsaW5hZ29yYS5jb20NCkFUVEVOREVFO0NVVFlQRT1JTkRJVklEVUFMO1JP\nTEU9UkVRLVBBUlRJQ0lQQU5UO1BBUlRTVEFUPUFDQ0VQVEVEO1JTVlA9VFJVRQ0KIDtDTj1B\nbnRvaW5lIER1cHJhdDtYLU5VTS1HVUVTVFM9MDptYWlsdG86YW50ZHVwcmF0QGdtYWlsLmNv\nbQ0KQ1JFQVRFRDoyMDE3MDExOVQxOTE4MjNaDQpERVNDUklQVElPTjpBZmZpY2hleiB2b3Ry\nZSDDqXbDqW5lbWVudCBzdXIgbGEgcGFnZSBodHRwczovL3d3dy5nb29nbGUuY29tL2NhbA0K\nIGVuZGFyL2V2ZW50P2FjdGlvbj1WSUVXJmVpZD1ZV2c0Tm1zMWJUTTBNbUp0WTNKaVpUbHJh\nR3RyYUd4dU1EQWdZV1IxY0hKaGRFQg0KIHNhVzVoWjI5eVlTNWpiMjAmdG9rPU1Ua2pZVzUw\nWkhWd2NtRjBRR2R0WVdsc0xtTnZiVGcxT1RNNU5XTTRNR1JsWW1FMVlUSTROeg0KIFJqTjJV\neU5qVTBNMll5Wm1RNE56UmtOVGhoWVRRJmN0ej1FdXJvcGUvUGFyaXMmaGw9ZnIuDQpMQVNU\nLU1PRElGSUVEOjIwMTcwMTE5VDE5MTgyM1oNCkxPQ0FUSU9OOg0KU0VRVUVOQ0U6MA0KU1RB\nVFVTOkNPTkZJUk1FRA0KU1VNTUFSWToNClRSQU5TUDpPUEFRVUUNCkVORDpWRVZFTlQNCkVO\nRDpWQ0FMRU5EQVINCg==";
    private static final String ICS_BASE64_UID = "ah86k5m342bmcrbe9khkkhln00@google.com";
    private static final String ICS_BASE64_DTSTAMP = "20170119T191823Z";
    private static final String ICS_YAHOO = "BEGIN:VCALENDAR\r\nPRODID://Yahoo//Calendar//EN\r\nVERSION:2.0\r\nMETHOD:REQUEST\r\nBEGIN:VEVENT\r\nSUMMARY:Test from Yahoo\r\nCLASS:PUBLIC\r\nDTSTART;TZID=Europe/Brussels:20170127T150000\r\nDTEND;TZID=Europe/Brussels:20170127T160000\r\nLOCATION:Somewhere\r\nPRIORITY:0\r\nSEQUENCE:0\r\nSTATUS:CONFIRMED\r\nUID:5014513f-1026-4b58-82cf-80d4fc060bbe\r\nDTSTAMP:20170123T121635Z\r\nATTENDEE;PARTSTAT=NEEDS-ACTION;ROLE=REQ_PARTICIPANT;RSVP=TRUE;SCHEDULE-STAT\r\n US=1.1:mailto:ddolcimascolo@linagora.com\r\nATTENDEE;PARTSTAT=NEEDS-ACTION;ROLE=REQ_PARTICIPANT;RSVP=TRUE;SCHEDULE-STAT\r\n US=1.1:mailto:rouazana@linagora.com\r\nATTENDEE;PARTSTAT=NEEDS-ACTION;ROLE=REQ_PARTICIPANT;RSVP=TRUE;SCHEDULE-STAT\r\n US=1.1:mailto:aduprat@linagora.com\r\nATTENDEE;PARTSTAT=NEEDS-ACTION;ROLE=REQ_PARTICIPANT;RSVP=TRUE;SCHEDULE-STAT\r\n US=1.1:mailto:btellier@linagora.com\r\nORGANIZER;CN=OBM Linagora;SENT-BY=\"mailto:obmlinagora@yahoo.fr\":mailto:obml\r\n inagora@yahoo.fr\r\nX-YAHOO-YID:obmlinagora\r\nTRANSP:OPAQUE\r\nSTATUS:CONFIRMED\r\nX-YAHOO-USER-STATUS:BUSY\r\nX-YAHOO-EVENT-STATUS:BUSY\r\nEND:VEVENT\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Brussels\r\nTZURL:http://tzurl.org/zoneinfo/Europe/Brussels\r\nX-LIC-LOCATION:Europe/Brussels\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+001730\r\nTZOFFSETTO:+001730\r\nTZNAME:BMT\r\nDTSTART:18800101T000000\r\nRDATE:18800101T000000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+001730\r\nTZOFFSETTO:+0000\r\nTZNAME:WET\r\nDTSTART:18920501T120000\r\nRDATE:18920501T120000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19141108T000000\r\nRDATE:19141108T000000\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19160501T000000\r\nRDATE:19160501T000000\r\nRDATE:19170416T020000\r\nRDATE:19180415T020000\r\nRDATE:19400520T030000\r\nRDATE:19430329T020000\r\nRDATE:19440403T020000\r\nRDATE:19450402T020000\r\nRDATE:19460519T020000\r\nRDATE:19770403T020000\r\nRDATE:19780402T020000\r\nRDATE:19790401T020000\r\nRDATE:19800406T020000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19161001T010000\r\nRDATE:19161001T010000\r\nRDATE:19170917T030000\r\nRDATE:19180916T030000\r\nRDATE:19421102T030000\r\nRDATE:19431004T030000\r\nRDATE:19440917T030000\r\nRDATE:19450916T030000\r\nRDATE:19461007T030000\r\nRDATE:19770925T030000\r\nRDATE:19781001T030000\r\nRDATE:19790930T030000\r\nRDATE:19800928T030000\r\nRDATE:19810927T030000\r\nRDATE:19820926T030000\r\nRDATE:19830925T030000\r\nRDATE:19840930T030000\r\nRDATE:19850929T030000\r\nRDATE:19860928T030000\r\nRDATE:19870927T030000\r\nRDATE:19880925T030000\r\nRDATE:19890924T030000\r\nRDATE:19900930T030000\r\nRDATE:19910929T030000\r\nRDATE:19920927T030000\r\nRDATE:19930926T030000\r\nRDATE:19940925T030000\r\nRDATE:19950924T030000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:WET\r\nDTSTART:19181111T120000\r\nRDATE:19181111T120000\r\nRDATE:19191005T000000\r\nRDATE:19201024T000000\r\nRDATE:19211026T000000\r\nRDATE:19221008T000000\r\nRDATE:19231007T000000\r\nRDATE:19241005T000000\r\nRDATE:19251004T000000\r\nRDATE:19261003T000000\r\nRDATE:19271002T000000\r\nRDATE:19281007T030000\r\nRDATE:19291006T030000\r\nRDATE:19301005T030000\r\nRDATE:19311004T030000\r\nRDATE:19321002T030000\r\nRDATE:19331008T030000\r\nRDATE:19341007T030000\r\nRDATE:19351006T030000\r\nRDATE:19361004T030000\r\nRDATE:19371003T030000\r\nRDATE:19381002T030000\r\nRDATE:19391119T030000\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:WEST\r\nDTSTART:19190301T230000\r\nRDATE:19190301T230000\r\nRDATE:19200214T230000\r\nRDATE:19210314T230000\r\nRDATE:19220325T230000\r\nRDATE:19230421T230000\r\nRDATE:19240329T230000\r\nRDATE:19250404T230000\r\nRDATE:19260417T230000\r\nRDATE:19270409T230000\r\nRDATE:19280414T230000\r\nRDATE:19290421T020000\r\nRDATE:19300413T020000\r\nRDATE:19310419T020000\r\nRDATE:19320403T020000\r\nRDATE:19330326T020000\r\nRDATE:19340408T020000\r\nRDATE:19350331T020000\r\nRDATE:19360419T020000\r\nRDATE:19370404T020000\r\nRDATE:19380327T020000\r\nRDATE:19390416T020000\r\nRDATE:19400225T020000\r\nEND:DAYLIGHT\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19440903T000000\r\nRDATE:19440903T000000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19770101T000000\r\nRDATE:19770101T000000\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nEND:VCALENDAR\r\n";
    public SwarmGenericContainer rabbitMqContainer = new SwarmGenericContainer("rabbitmq:3").withAffinityToContainer();
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    public AmqpRule amqpRule = new AmqpRule(this.rabbitMqContainer, "myExchange", "myRoutingKey");
    @Rule
    public final RuleChain chain = RuleChain.outerRule((TestRule)this.temporaryFolder).around((TestRule)this.rabbitMqContainer).around((TestRule)this.amqpRule);
    private ConditionFactory calmlyAwait;
    private TemporaryJamesServer jamesServer;
    private MimeMessage messageWithoutICSAttached;
    private MimeMessage messageWithICSAttached;
    private MimeMessage messageWithICSBase64Attached;
    private MimeMessage messageWithThreeICSAttached;
    private MimeMessage yahooInvitationMessage;

    @Before
    public void setup() throws Exception {
        MailetContainer mailetContainer = MailetContainer.builder().postmaster("postmaster@james.org").threads(5).addProcessor(CommonProcessors.root()).addProcessor(CommonProcessors.error()).addProcessor(ProcessorConfiguration.builder().state("transport").enableJmx(true).addMailet(MailetConfiguration.builder().match("All").clazz("RemoveMimeHeader").addProperty("name", "bcc").build()).addMailet(MailetConfiguration.builder().match("All").clazz("StripAttachment").addProperty("attribute", MAIL_ATTRIBUTE).addProperty("pattern", ".*").build()).addMailet(MailetConfiguration.builder().match("All").clazz("MimeDecodingMailet").addProperty("attribute", MAIL_ATTRIBUTE).build()).addMailet(MailetConfiguration.builder().match("All").clazz("ICalendarParser").addProperty("sourceAttribute", MAIL_ATTRIBUTE).addProperty("destinationAttribute", PARSED_ICAL_MAIL_ATTRIBUTE).build()).addMailet(MailetConfiguration.builder().match("All").clazz("ICALToHeader").addProperty("attribute", PARSED_ICAL_MAIL_ATTRIBUTE).build()).addMailet(MailetConfiguration.builder().match("All").clazz("ICALToJsonAttribute").addProperty("source", PARSED_ICAL_MAIL_ATTRIBUTE).addProperty("rawSource", MAIL_ATTRIBUTE).addProperty("destination", JSON_MAIL_ATTRIBUTE).build()).addMailet(MailetConfiguration.builder().match("All").clazz("AmqpForwardAttribute").addProperty("uri", this.amqpRule.getAmqpUri()).addProperty("exchange", EXCHANGE_NAME).addProperty("attribute", JSON_MAIL_ATTRIBUTE).addProperty("routing_key", ROUTING_KEY).build()).addMailet(MailetConfiguration.builder().match("RecipientIsLocal").clazz("org.apache.james.jmap.mailet.VacationMailet").build()).addMailet(MailetConfiguration.builder().match("RecipientIsLocal").clazz("LocalDelivery").build()).build()).build();
        this.jamesServer = new TemporaryJamesServer(this.temporaryFolder, mailetContainer, new Module[0]);
        Duration slowPacedPollInterval = Duration.FIVE_HUNDRED_MILLISECONDS;
        this.calmlyAwait = Awaitility.with().pollInterval(slowPacedPollInterval).and().with().pollDelay(slowPacedPollInterval).await();
        DataProbe dataProbe = (DataProbe)this.jamesServer.getProbe(DataProbeImpl.class);
        dataProbe.addDomain(JAMES_APACHE_ORG);
        dataProbe.addUser(FROM, PASSWORD);
        dataProbe.addUser(RECIPIENT, PASSWORD);
        this.jamesServer.getProbe(MailboxProbeImpl.class).createMailbox("#private", RECIPIENT, "INBOX");
        this.messageWithoutICSAttached = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new BodyPart[]{MimeMessageBuilder.bodyPartBuilder().data("simple text").build(), MimeMessageBuilder.bodyPartBuilder().data("My attachment").filename("test.txt").disposition("attachment").build()}).setSubject("test").build();
        this.messageWithICSAttached = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new BodyPart[]{MimeMessageBuilder.bodyPartBuilder().data("simple text").build(), MimeMessageBuilder.bodyPartBuilder().data(ICS_1.getBytes(Charsets.UTF_8)).filename("meeting.ics").disposition("attachment").build()}).setSubject("test").build();
        this.messageWithICSBase64Attached = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new BodyPart[]{MimeMessageBuilder.bodyPartBuilder().data("simple text").build(), MimeMessageBuilder.bodyPartFromBytes((byte[])ICS_BASE64.getBytes(Charsets.UTF_8))}).setSubject("test").build();
        this.yahooInvitationMessage = MimeMessageBuilder.mimeMessageFromStream((InputStream)ClassLoader.getSystemResourceAsStream("eml/yahooInvitation.eml"));
        this.messageWithThreeICSAttached = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new BodyPart[]{MimeMessageBuilder.bodyPartBuilder().data("simple text").build(), MimeMessageBuilder.bodyPartBuilder().data(ICS_1.getBytes(Charsets.UTF_8)).filename("test1.txt").disposition("attachment").build(), MimeMessageBuilder.bodyPartBuilder().data(ICS_2.getBytes(Charsets.UTF_8)).filename("test2.txt").disposition("attachment").build(), MimeMessageBuilder.bodyPartBuilder().data(ICS_3.getBytes(Charsets.UTF_8)).filename("test3.txt").disposition("attachment").build()}).setSubject("test").build();
    }

    @After
    public void tearDown() throws Exception {
        this.jamesServer.shutdown();
    }

    @Test
    public void calendarAttachmentShouldNotBePublishedInMQWhenNoICalAttachment() throws Exception {
        FakeMail mail = FakeMail.builder().mimeMessage(this.messageWithoutICSAttached).sender(new MailAddress(FROM)).recipient(new MailAddress(RECIPIENT)).build();
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage((Mail)mail);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
        }
        Assertions.assertThat(this.amqpRule.readContent()).isEmpty();
    }

    @Test
    public void calendarAttachmentShouldBePublishedInMQWhenMatchingWorkflowConfiguration() throws Exception {
        FakeMail mail = FakeMail.builder().mimeMessage(this.messageWithICSAttached).sender(new MailAddress(FROM)).recipient(new MailAddress(RECIPIENT)).build();
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage((Mail)mail);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
        }
        Optional<String> content = this.amqpRule.readContent();
        Assertions.assertThat(content).isPresent();
        DocumentContext jsonPath = this.toJsonPath(content.get());
        Assertions.assertThat((String)((String)jsonPath.read("ical", new Predicate[0]))).isEqualTo((Object)ICS_1);
        Assertions.assertThat((String)((String)jsonPath.read("sender", new Predicate[0]))).isEqualTo((Object)FROM);
        Assertions.assertThat((String)((String)jsonPath.read("recipient", new Predicate[0]))).isEqualTo((Object)RECIPIENT);
        Assertions.assertThat((String)((String)jsonPath.read("uid", new Predicate[0]))).isEqualTo((Object)ICS_UID);
        Assertions.assertThat((String)((String)jsonPath.read("sequence", new Predicate[0]))).isEqualTo((Object)ICS_SEQUENCE);
        Assertions.assertThat((String)((String)jsonPath.read("dtstamp", new Predicate[0]))).isEqualTo((Object)ICS_DTSTAMP);
        Assertions.assertThat((String)((String)jsonPath.read("method", new Predicate[0]))).isEqualTo((Object)ICS_METHOD);
        Assertions.assertThat((String)((String)jsonPath.read("recurrence-id", new Predicate[0]))).isNull();
    }

    private DocumentContext toJsonPath(String content) {
        return JsonPath.using((Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS})).parse(content);
    }

    @Test
    public void headersShouldNotBeAddedInMailWhenNoICalAttachment() throws Exception {
        FakeMail mail = FakeMail.builder().mimeMessage(this.messageWithoutICSAttached).sender(new MailAddress(FROM)).recipient(new MailAddress(RECIPIENT)).build();
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage((Mail)mail);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
            String receivedHeaders = imapMessageReader.readFirstMessageHeadersInInbox(RECIPIENT, PASSWORD);
            Assertions.assertThat((String)receivedHeaders).doesNotContain((CharSequence)"X-MEETING-UID");
            Assertions.assertThat((String)receivedHeaders).doesNotContain((CharSequence)"X-MEETING-METHOD");
            Assertions.assertThat((String)receivedHeaders).doesNotContain((CharSequence)"X-MEETING-RECURRENCE-ID");
            Assertions.assertThat((String)receivedHeaders).doesNotContain((CharSequence)"X-MEETING-SEQUENCE");
            Assertions.assertThat((String)receivedHeaders).doesNotContain((CharSequence)"X-MEETING-DTSTAMP");
        }
    }

    @Test
    public void headersShouldBeAddedInMailWhenOneICalAttachment() throws Exception {
        FakeMail mail = FakeMail.builder().mimeMessage(this.messageWithICSAttached).sender(new MailAddress(FROM)).recipient(new MailAddress(RECIPIENT)).build();
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage((Mail)mail);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
            String receivedHeaders = imapMessageReader.readFirstMessageHeadersInInbox(RECIPIENT, PASSWORD);
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-UID: f1514f44bf39311568d640727cff54e819573448d09d2e5677987ff29caa01a9e047feb2aab16e43439a608f28671ab7c10e754ce92be513f8e04ae9ff15e65a9819cf285a6962bc"});
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-METHOD: REQUEST"});
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-SEQUENCE: 0"});
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-DTSTAMP: 20170106T115036Z"});
        }
    }

    @Test
    public void headersShouldBeAddedInMailWhenOneBase64ICalAttachment() throws Exception {
        FakeMail mail = FakeMail.builder().mimeMessage(this.messageWithICSBase64Attached).sender(new MailAddress(FROM)).recipient(new MailAddress(RECIPIENT)).build();
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage((Mail)mail);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
            String receivedHeaders = imapMessageReader.readFirstMessageHeadersInInbox(RECIPIENT, PASSWORD);
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-UID: ah86k5m342bmcrbe9khkkhln00@google.com"});
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-METHOD: REQUEST"});
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-SEQUENCE: 0"});
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-DTSTAMP: 20170119T191823Z"});
        }
    }

    @Test
    public void base64CalendarAttachmentShouldBePublishedInMQWhenMatchingWorkflowConfiguration() throws Exception {
        FakeMail mail = FakeMail.builder().mimeMessage(this.messageWithICSBase64Attached).sender(new MailAddress(FROM)).recipient(new MailAddress(RECIPIENT)).build();
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage((Mail)mail);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
        }
        Optional<String> content = this.amqpRule.readContent();
        Assertions.assertThat(content).isPresent();
        DocumentContext jsonPath = this.toJsonPath(content.get());
        Assertions.assertThat((String)((String)jsonPath.read("sender", new Predicate[0]))).isEqualTo((Object)FROM);
        Assertions.assertThat((String)((String)jsonPath.read("recipient", new Predicate[0]))).isEqualTo((Object)RECIPIENT);
        Assertions.assertThat((String)((String)jsonPath.read("uid", new Predicate[0]))).isEqualTo((Object)ICS_BASE64_UID);
        Assertions.assertThat((String)((String)jsonPath.read("sequence", new Predicate[0]))).isEqualTo((Object)ICS_SEQUENCE);
        Assertions.assertThat((String)((String)jsonPath.read("dtstamp", new Predicate[0]))).isEqualTo((Object)ICS_BASE64_DTSTAMP);
        Assertions.assertThat((String)((String)jsonPath.read("method", new Predicate[0]))).isEqualTo((Object)ICS_METHOD);
        Assertions.assertThat((String)((String)jsonPath.read("recurrence-id", new Predicate[0]))).isNull();
    }

    @Test
    public void yahooBase64CalendarAttachmentShouldBePublishedInMQWhenMatchingWorkflowConfiguration() throws Exception {
        FakeMail mail = FakeMail.builder().mimeMessage(this.yahooInvitationMessage).sender(new MailAddress(FROM)).recipient(new MailAddress(RECIPIENT)).build();
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage((Mail)mail);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
        }
        Optional<String> content = this.amqpRule.readContent();
        Assertions.assertThat(content).isPresent();
        DocumentContext jsonPath = this.toJsonPath(content.get());
        Assertions.assertThat((String)((String)jsonPath.read("sender", new Predicate[0]))).isEqualTo((Object)"obmlinagora@yahoo.fr");
        Assertions.assertThat((String)((String)jsonPath.read("recipient", new Predicate[0]))).isEqualTo((Object)RECIPIENT);
        Assertions.assertThat((String)((String)jsonPath.read("uid", new Predicate[0]))).isEqualTo((Object)"5014513f-1026-4b58-82cf-80d4fc060bbe");
        Assertions.assertThat((String)((String)jsonPath.read("sequence", new Predicate[0]))).isEqualTo((Object)ICS_SEQUENCE);
        Assertions.assertThat((String)((String)jsonPath.read("dtstamp", new Predicate[0]))).isEqualTo((Object)"20170123T121635Z");
        Assertions.assertThat((String)((String)jsonPath.read("method", new Predicate[0]))).isEqualTo((Object)ICS_METHOD);
        Assertions.assertThat((String)((String)jsonPath.read("ical", new Predicate[0]))).isEqualTo((Object)ICS_YAHOO);
        Assertions.assertThat((String)((String)jsonPath.read("recurrence-id", new Predicate[0]))).isNull();
    }

    @Test
    public void headersShouldBeFilledOnlyWithOneICalAttachmentWhenMailHasSeveral() throws Exception {
        FakeMail mail = FakeMail.builder().mimeMessage(this.messageWithThreeICSAttached).sender(new MailAddress(FROM)).recipient(new MailAddress(RECIPIENT)).build();
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage((Mail)mail);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
            String receivedHeaders = imapMessageReader.readFirstMessageHeadersInInbox(RECIPIENT, PASSWORD);
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-UID: f1514f44bf39311568d640727cff54e819573448d09d2e5677987ff29caa01a9e047feb2aab16e43439a608f28671ab7c10e754ce92be513f8e04ae9ff15e65a9819cf285a6962bc"});
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-METHOD: REQUEST"});
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-SEQUENCE: 0"});
            Assertions.assertThat((String)receivedHeaders).contains(new CharSequence[]{"X-MEETING-DTSTAMP: 20170106T115036Z"});
        }
    }

    @Test
    public void pipelineShouldSendSeveralJSONOverRabbitMQWhenSeveralAttachments() throws Exception {
        FakeMail mail = FakeMail.builder().mimeMessage(this.messageWithThreeICSAttached).sender(new MailAddress(FROM)).recipient(new MailAddress(RECIPIENT)).build();
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage((Mail)mail);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
        }
        Optional<String> content1 = this.amqpRule.readContent();
        Assertions.assertThat(content1).isPresent();
        DocumentContext jsonPath1 = this.toJsonPath(content1.get());
        Optional<String> content2 = this.amqpRule.readContent();
        Assertions.assertThat(content2).isPresent();
        DocumentContext jsonPath2 = this.toJsonPath(content2.get());
        Optional<String> content3 = this.amqpRule.readContent();
        Assertions.assertThat(content3).isPresent();
        DocumentContext jsonPath3 = this.toJsonPath(content3.get());
        Assertions.assertThat((List)ImmutableList.of((Object)jsonPath1.read("uid", new Predicate[0]), (Object)jsonPath2.read("uid", new Predicate[0]), (Object)jsonPath3.read("uid", new Predicate[0]))).containsOnly(new Object[]{ICS_UID, "f1514f44bf39311568d640727cff54e819573448d09d2e5677987ff29caa01a9e047feb2aab16e43439a608f28671ab7c10e754ce92be513f8e04ae9ff15e65a9819cf285a6962bd", "f1514f44bf39311568d640727cff54e819573448d09d2e5677987ff29caa01a9e047feb2aab16e43439a608f28671ab7c10e754ce92be513f8e04ae9ff15e65a9819cf285a6962be"});
        Assertions.assertThat(this.amqpRule.readContent()).isEmpty();
    }
}

