/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Charsets;
import com.google.inject.Module;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionFactory;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.james.mailets.TemporaryJamesServer;
import org.apache.james.mailets.configuration.CommonProcessors;
import org.apache.james.mailets.configuration.MailetConfiguration;
import org.apache.james.mailets.configuration.MailetContainer;
import org.apache.james.mailets.configuration.ProcessorConfiguration;
import org.apache.james.mailets.utils.SMTPMessageSender;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.transport.mailets.amqp.AmqpRule;
import org.apache.james.util.streams.SwarmGenericContainer;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.IMAPMessageReader;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.MimeMessageBuilder;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class AmqpForwardAttachmentTest {
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int IMAP_PORT = 1143;
    private static final int SMTP_PORT = 1025;
    private static final String PASSWORD = "secret";
    private static final String JAMES_APACHE_ORG = "james.org";
    private static final String FROM = "fromUser@james.org";
    private static final String RECIPIENT = "touser@james.org";
    private static final String MAIL_ATTRIBUTE = "my.attribute";
    private static final String EXCHANGE_NAME = "myExchange";
    private static final String ROUTING_KEY = "myRoutingKey";
    private static final byte[] TEST_ATTACHMENT_CONTENT = "Test attachment content".getBytes(Charsets.UTF_8);
    public SwarmGenericContainer rabbitMqContainer = new SwarmGenericContainer("rabbitmq:3").withAffinityToContainer();
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    public AmqpRule amqpRule = new AmqpRule(this.rabbitMqContainer, "myExchange", "myRoutingKey");
    @Rule
    public final RuleChain chain = RuleChain.outerRule((TestRule)this.temporaryFolder).around((TestRule)this.rabbitMqContainer).around((TestRule)this.amqpRule);
    private TemporaryJamesServer jamesServer;
    private ConditionFactory calmlyAwait;

    @Before
    public void setup() throws Exception {
        MailetContainer mailetContainer = MailetContainer.builder().postmaster("postmaster@james.org").threads(5).addProcessor(CommonProcessors.root()).addProcessor(CommonProcessors.error()).addProcessor(ProcessorConfiguration.builder().state("transport").enableJmx(true).addMailet(MailetConfiguration.builder().match("All").clazz("RemoveMimeHeader").addProperty("name", "bcc").build()).addMailet(MailetConfiguration.builder().match("All").clazz("StripAttachment").addProperty("attribute", MAIL_ATTRIBUTE).addProperty("pattern", ".*\\.txt").build()).addMailet(MailetConfiguration.builder().match("All").clazz("MimeDecodingMailet").addProperty("attribute", MAIL_ATTRIBUTE).build()).addMailet(MailetConfiguration.builder().match("All").clazz("AmqpForwardAttribute").addProperty("uri", this.amqpRule.getAmqpUri()).addProperty("exchange", EXCHANGE_NAME).addProperty("attribute", MAIL_ATTRIBUTE).addProperty("routing_key", ROUTING_KEY).build()).addMailet(MailetConfiguration.builder().match("RecipientIsLocal").clazz("org.apache.james.jmap.mailet.VacationMailet").build()).addMailet(MailetConfiguration.builder().match("RecipientIsLocal").clazz("LocalDelivery").build()).build()).build();
        this.jamesServer = new TemporaryJamesServer(this.temporaryFolder, mailetContainer, new Module[0]);
        Duration slowPacedPollInterval = Duration.FIVE_HUNDRED_MILLISECONDS;
        this.calmlyAwait = Awaitility.with().pollInterval(slowPacedPollInterval).and().with().pollDelay(slowPacedPollInterval).await();
        DataProbe dataprobe = (DataProbe)this.jamesServer.getProbe(DataProbeImpl.class);
        dataprobe.addDomain(JAMES_APACHE_ORG);
        dataprobe.addUser(FROM, PASSWORD);
        dataprobe.addUser(RECIPIENT, PASSWORD);
        this.jamesServer.getProbe(MailboxProbeImpl.class).createMailbox("#private", RECIPIENT, "INBOX");
    }

    @After
    public void tearDown() throws Exception {
        this.jamesServer.shutdown();
    }

    @Test
    public void stripAttachmentShouldPutAttachmentsInMailAttributeWhenConfiguredForIt() throws Exception {
        MimeMessage message = MimeMessageBuilder.mimeMessageBuilder().setMultipartWithBodyParts(new BodyPart[]{MimeMessageBuilder.bodyPartBuilder().data("simple text").build(), MimeMessageBuilder.bodyPartBuilder().data(TEST_ATTACHMENT_CONTENT).disposition("attachment").filename("test.txt").build()}).setSubject("test").build();
        FakeMail mail = FakeMail.builder().mimeMessage(message).sender(new MailAddress(FROM)).recipient(new MailAddress(RECIPIENT)).build();
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage((Mail)mail);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
        }
        Assertions.assertThat(this.amqpRule.readContentAsBytes()).contains((Object)TEST_ATTACHMENT_CONTENT);
    }
}

