/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.net.smtp.AuthenticatingSMTPClient;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.mailet.Mail;

public class SMTPMessageSender
implements Closeable {
    private final SMTPClient smtpClient;
    private final String senderDomain;

    public static SMTPMessageSender noAuthentication(String ip, int port, String senderDomain) throws IOException {
        SMTPClient smtpClient = new SMTPClient();
        smtpClient.connect(ip, port);
        return new SMTPMessageSender(smtpClient, senderDomain);
    }

    public static SMTPMessageSender authentication(String ip, int port, String senderDomain, String username, String password) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException, InvalidKeyException {
        AuthenticatingSMTPClient smtpClient = new AuthenticatingSMTPClient();
        smtpClient.connect(ip, port);
        smtpClient.auth(AuthenticatingSMTPClient.AUTH_METHOD.PLAIN, username, password);
        return new SMTPMessageSender((SMTPClient)smtpClient, senderDomain);
    }

    private SMTPMessageSender(SMTPClient smtpClient, String senderDomain) {
        this.smtpClient = smtpClient;
        this.senderDomain = senderDomain;
    }

    public void sendMessage(String from, String recipient) {
        try {
            this.smtpClient.helo(this.senderDomain);
            this.smtpClient.setSender(from);
            this.smtpClient.rcpt("<" + recipient + ">");
            this.smtpClient.sendShortMessageData("FROM: " + from + "\r\nsubject: test\r\n\r\ncontent\r\n.\r\n");
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void sendMessageWithHeaders(String from, String recipient, String message) {
        try {
            this.smtpClient.helo(this.senderDomain);
            this.smtpClient.setSender(from);
            this.smtpClient.rcpt("<" + recipient + ">");
            this.smtpClient.sendShortMessageData(message);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void sendMessage(Mail mail) throws MessagingException {
        try {
            String from = mail.getSender().asString();
            this.smtpClient.helo(this.senderDomain);
            this.smtpClient.setSender(from);
            this.smtpClient.rcpt("<" + Joiner.on((String)", ").join((Iterable)mail.getRecipients()) + ">");
            this.smtpClient.sendShortMessageData(this.asString((Message)mail.getMessage()));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String asString(Message message) throws IOException, MessagingException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        message.writeTo((OutputStream)outputStream);
        return new String(outputStream.toByteArray(), Charsets.UTF_8);
    }

    public boolean messageHasBeenSent() throws IOException {
        return this.smtpClient.getReplyString().contains("250 2.6.0 Message received");
    }

    @Override
    public void close() throws IOException {
        this.smtpClient.disconnect();
    }
}

