/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets.crypto;

import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionFactory;
import java.time.ZonedDateTime;
import org.apache.james.mailets.TemporaryJamesServer;
import org.apache.james.mailets.configuration.CommonProcessors;
import org.apache.james.mailets.configuration.MailetConfiguration;
import org.apache.james.mailets.configuration.MailetContainer;
import org.apache.james.mailets.configuration.ProcessorConfiguration;
import org.apache.james.mailets.utils.SMTPMessageSender;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.IMAPMessageReader;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SMIMESignIntegrationTest {
    private static final ZonedDateTime DATE_2015 = ZonedDateTime.parse("2015-10-15T14:10:00Z");
    private static final String DEFAULT_DOMAIN = "domain";
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int IMAP_PORT = 1143;
    private static final int SMTP_PORT = 1025;
    private static final int SMTP_SECURE_PORT = 10465;
    private static final String PASSWORD = "secret";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private TemporaryJamesServer jamesServer;
    private ConditionFactory calmlyAwait;
    public static final String FROM = "user@domain";
    public static final String RECIPIENT = "user2@domain";

    @Before
    public void setup() throws Exception {
        MailetContainer mailetContainer = MailetContainer.builder().postmaster("postmaster@domain").threads(5).addProcessor(CommonProcessors.root()).addProcessor(CommonProcessors.error()).addProcessor(ProcessorConfiguration.builder().state("transport").enableJmx(true).addMailet(MailetConfiguration.builder().match("SMTPAuthSuccessful").clazz("SetMimeHeader").addProperty("name", "X-UserIsAuth").addProperty("value", "true").build()).addMailet(MailetConfiguration.builder().match("HasMailAttribute=org.apache.james.SMIMECheckSignature").clazz("SetMimeHeader").addProperty("name", "X-WasSigned").addProperty("value", "true").build()).addMailet(MailetConfiguration.builder().match("All").clazz("RemoveMimeHeader").addProperty("name", "bcc").build()).addMailet(MailetConfiguration.builder().match("All").clazz("RecipientRewriteTable").build()).addMailet(MailetConfiguration.builder().match("RecipientIsLocal").clazz("org.apache.james.jmap.mailet.VacationMailet").build()).addMailet(MailetConfiguration.builder().clazz("SMIMESign").match("SenderIsLocal").addProperty("keyStoreFileName", this.temporaryFolder.getRoot().getAbsoluteFile().getAbsolutePath() + "/conf/smime.p12").addProperty("keyStorePassword", PASSWORD).addProperty("keyStoreType", "PKCS12").addProperty("debug", "true").build()).addMailet(MailetConfiguration.builder().match("RecipientIsLocal").clazz("LocalDelivery").build()).addMailet(MailetConfiguration.builder().match("SMTPAuthSuccessful").clazz("RemoteDelivery").addProperty("outgoingQueue", "outgoing").addProperty("delayTime", "5000, 100000, 500000").addProperty("maxRetries", "25").addProperty("maxDnsProblemRetries", "0").addProperty("deliveryThreads", "10").addProperty("sendpartial", "true").addProperty("bounceProcessor", "bounces").build()).addMailet(MailetConfiguration.builder().match("All").clazz("ToProcessor").addProperty("processor", "relay-denied").build()).build()).addProcessor(CommonProcessors.spam()).addProcessor(CommonProcessors.localAddressError()).addProcessor(CommonProcessors.relayDenied()).addProcessor(CommonProcessors.bounces()).addProcessor(CommonProcessors.sieveManagerCheck()).build();
        this.jamesServer = new TemporaryJamesServer(this.temporaryFolder, mailetContainer, binder -> binder.bind(ZonedDateTimeProvider.class).toInstance(() -> DATE_2015));
        Duration slowPacedPollInterval = Duration.FIVE_HUNDRED_MILLISECONDS;
        this.calmlyAwait = Awaitility.with().pollInterval(slowPacedPollInterval).and().with().pollDelay(slowPacedPollInterval).await();
        DataProbe dataProbe = (DataProbe)this.jamesServer.getProbe(DataProbeImpl.class);
        dataProbe.addDomain(DEFAULT_DOMAIN);
        dataProbe.addUser(FROM, PASSWORD);
        dataProbe.addUser(RECIPIENT, PASSWORD);
        this.jamesServer.getProbe(MailboxProbeImpl.class).createMailbox("#private", RECIPIENT, "INBOX");
    }

    @After
    public void tearDown() {
        this.jamesServer.shutdown();
    }

    @Test
    public void authenticatedMessagesShouldBeSigned() throws Exception {
        try (SMTPMessageSender messageSender = SMTPMessageSender.authentication(LOCALHOST_IP, 10465, DEFAULT_DOMAIN, FROM, PASSWORD);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage(FROM, RECIPIENT);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
            Assertions.assertThat((String)imapMessageReader.readFirstMessageInInbox(RECIPIENT, PASSWORD)).containsSequence(new CharSequence[]{"Content-Description: S/MIME Cryptographic Signature"});
        }
    }

    @Test
    public void NonAuthenticatedMessagesShouldNotBeSigned() throws Exception {
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, DEFAULT_DOMAIN);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage(FROM, RECIPIENT);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(RECIPIENT, PASSWORD));
            Assertions.assertThat((String)imapMessageReader.readFirstMessageInInbox(RECIPIENT, PASSWORD)).doesNotContain((CharSequence)"Content-Description: S/MIME Cryptographic Signature");
        }
    }
}

