/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets.crypto;

import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionFactory;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailets.TemporaryJamesServer;
import org.apache.james.mailets.configuration.CommonProcessors;
import org.apache.james.mailets.configuration.MailetConfiguration;
import org.apache.james.mailets.configuration.MailetContainer;
import org.apache.james.mailets.configuration.ProcessorConfiguration;
import org.apache.james.mailets.utils.SMTPMessageSender;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.IMAPMessageReader;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SMIMEDecryptIntegrationTest {
    private static final ZonedDateTime DATE_2015 = ZonedDateTime.parse("2015-10-15T14:10:00Z");
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int IMAP_PORT = 1143;
    private static final int SMTP_SECURE_PORT = 10465;
    private static final String DEFAULT_DOMAIN = "localdomain";
    private static final String FROM = "sender@localdomain";
    private static final String PASSWORD = "secret";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private TemporaryJamesServer jamesServer;
    private ConditionFactory calmlyAwait;

    @Before
    public void setup() throws Exception {
        MailetContainer mailetContainer = MailetContainer.builder().postmaster("postmaster@localdomain").threads(5).addProcessor(CommonProcessors.root()).addProcessor(CommonProcessors.error()).addProcessor(ProcessorConfiguration.builder().state("transport").enableJmx(true).addMailet(MailetConfiguration.builder().match("All").clazz("RemoveMimeHeader").addProperty("name", "bcc").build()).addMailet(MailetConfiguration.builder().clazz("SMIMEDecrypt").match("All").addProperty("keyStoreFileName", this.temporaryFolder.getRoot().getAbsoluteFile().getAbsolutePath() + "/conf/smime.p12").addProperty("keyStorePassword", PASSWORD).addProperty("keyStoreType", "PKCS12").addProperty("debug", "true").build()).addMailet(MailetConfiguration.builder().match("RecipientIsLocal").clazz("org.apache.james.jmap.mailet.VacationMailet").build()).addMailet(MailetConfiguration.builder().match("RecipientIsLocal").clazz("LocalDelivery").build()).build()).build();
        this.jamesServer = new TemporaryJamesServer(this.temporaryFolder, mailetContainer, binder -> binder.bind(ZonedDateTimeProvider.class).toInstance(() -> DATE_2015));
        Duration slowPacedPollInterval = Duration.FIVE_HUNDRED_MILLISECONDS;
        this.calmlyAwait = Awaitility.with().pollInterval(slowPacedPollInterval).and().with().pollDelay(slowPacedPollInterval).await();
        DataProbeImpl serverProbe = this.jamesServer.getProbe(DataProbeImpl.class);
        serverProbe.addDomain(DEFAULT_DOMAIN);
        serverProbe.addUser(FROM, PASSWORD);
        MailboxProbeImpl mailboxProbe = this.jamesServer.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox("#private", FROM, "INBOX");
    }

    @After
    public void tearDown() {
        this.jamesServer.shutdown();
    }

    @Test
    public void cryptedMessageShouldBeDecryptedWhenCertificateMatches() throws Exception {
        try (SMTPMessageSender messageSender = SMTPMessageSender.authentication(LOCALHOST_IP, 10465, DEFAULT_DOMAIN, FROM, PASSWORD);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessageWithHeaders(FROM, FROM, IOUtils.toString((InputStream)ClassLoader.getSystemResourceAsStream("eml/crypted.eml"), (Charset)StandardCharsets.US_ASCII));
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(FROM, PASSWORD));
            Assertions.assertThat((String)imapMessageReader.readFirstMessageInInbox(FROM, PASSWORD)).containsSequence(new CharSequence[]{"Crypted content"});
        }
    }

    @Test
    public void cryptedMessageWithAttachmentShouldBeDecryptedWhenCertificateMatches() throws Exception {
        try (SMTPMessageSender messageSender = SMTPMessageSender.authentication(LOCALHOST_IP, 10465, DEFAULT_DOMAIN, FROM, PASSWORD);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessageWithHeaders(FROM, FROM, IOUtils.toString((InputStream)ClassLoader.getSystemResourceAsStream("eml/crypted_with_attachment.eml"), (Charset)StandardCharsets.US_ASCII));
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(FROM, PASSWORD));
            Assertions.assertThat((String)imapMessageReader.readFirstMessageInInbox(FROM, PASSWORD)).containsSequence(new CharSequence[]{"Crypted Content with attachment"});
        }
    }

    @Test
    public void cryptedMessageShouldNotBeDecryptedWhenCertificateDoesntMatch() throws Exception {
        try (SMTPMessageSender messageSender = SMTPMessageSender.authentication(LOCALHOST_IP, 10465, DEFAULT_DOMAIN, FROM, PASSWORD);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessageWithHeaders(FROM, FROM, IOUtils.toString((InputStream)ClassLoader.getSystemResourceAsStream("eml/bad_crypted.eml"), (Charset)StandardCharsets.US_ASCII));
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(FROM, PASSWORD));
            Assertions.assertThat((String)imapMessageReader.readFirstMessageInInbox(FROM, PASSWORD)).containsSequence(new CharSequence[]{"MIAGCSqGSIb3DQEHA6CAMIACAQAxggKpMIICpQIBADCBjDCBhjELMAkGA1UE"});
        }
    }
}

