/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import org.apache.james.mailets.configuration.MailetConfiguration;
import org.apache.james.mailets.configuration.SerializableAsXml;

public class ProcessorConfiguration
implements SerializableAsXml {
    private final String state;
    private final boolean enableJmx;
    private final ImmutableList<MailetConfiguration> mailets;

    public static Builder builder() {
        return new Builder();
    }

    private ProcessorConfiguration(String state, boolean enableJmx, ImmutableList<MailetConfiguration> mailets) {
        this.state = state;
        this.enableJmx = enableJmx;
        this.mailets = mailets;
    }

    public String getState() {
        return this.state;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public ImmutableList<MailetConfiguration> getMailets() {
        return this.mailets;
    }

    @Override
    public String serializeAsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<processor state=\"").append(this.getState()).append("\" enableJmx=\"").append(this.isEnableJmx() ? "true" : "false").append("\">\n");
        for (MailetConfiguration mailet : this.getMailets()) {
            builder.append(mailet.serializeAsXml());
        }
        builder.append("</processor>\n");
        return builder.toString();
    }

    public static class Builder {
        private String state;
        private boolean enableJmx;
        private ImmutableList.Builder<MailetConfiguration> mailets = ImmutableList.builder();

        private Builder() {
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder enableJmx(boolean enableJmx) {
            this.enableJmx = enableJmx;
            return this;
        }

        public Builder addMailet(MailetConfiguration mailetConfiguration) {
            this.mailets.add((Object)mailetConfiguration);
            return this;
        }

        public ProcessorConfiguration build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.state) ? 1 : 0) != 0, (Object)"'state' is mandatory");
            return new ProcessorConfiguration(this.state, this.enableJmx, this.mailets.build());
        }
    }
}

