/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.mailets.configuration.ProcessorConfiguration;
import org.apache.james.mailets.configuration.SerializableAsXml;

public class MailetContainer
implements SerializableAsXml {
    private final String postmaster;
    private final int threads;
    private final List<ProcessorConfiguration> processors;

    public static Builder builder() {
        return new Builder();
    }

    private MailetContainer(String postmaster, int threads, List<ProcessorConfiguration> processors) {
        this.postmaster = postmaster;
        this.threads = threads;
        this.processors = processors;
    }

    public String getPostmaster() {
        return this.postmaster;
    }

    public int getThreads() {
        return this.threads;
    }

    public List<ProcessorConfiguration> getProcessors() {
        return this.processors;
    }

    @Override
    public String serializeAsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\"?>\n").append("<mailetcontainer enableJmx=\"true\">\n").append("<context><postmaster>").append(this.getPostmaster()).append("</postmaster>").append("</context>\n").append("<spooler><threads>").append(this.getThreads()).append("</threads>").append("</spooler>\n").append("<processors>\n");
        for (ProcessorConfiguration processorConfiguration : this.getProcessors()) {
            builder.append(processorConfiguration.serializeAsXml());
        }
        builder.append("</processors>\n").append("</mailetcontainer>");
        return builder.toString();
    }

    public static class Builder {
        private String postmaster;
        private int threads;
        private ImmutableList.Builder<ProcessorConfiguration> processors = ImmutableList.builder();

        private Builder() {
        }

        public Builder postmaster(String postmaster) {
            this.postmaster = postmaster;
            return this;
        }

        public Builder threads(int threads) {
            this.threads = threads;
            return this;
        }

        public Builder addProcessor(ProcessorConfiguration processorConfiguration) {
            this.processors.add((Object)processorConfiguration);
            return this;
        }

        public MailetContainer build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.postmaster) ? 1 : 0) != 0, (Object)"'postmaster' is mandatory");
            Preconditions.checkState((this.threads > 0 ? 1 : 0) != 0, (Object)"'threads' should be greater than 0");
            return new MailetContainer(this.postmaster, this.threads, (List)this.processors.build());
        }
    }
}

