/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.james.mailets.configuration.SerializableAsXml;

public class MailetConfiguration
implements SerializableAsXml {
    private final String match;
    private final String clazz;
    private final Map<String, String> properties;

    public static Builder builder() {
        return new Builder();
    }

    private MailetConfiguration(String match, String clazz, ImmutableMap<String, String> properties) {
        this.match = match;
        this.clazz = clazz;
        this.properties = properties;
    }

    public String getMatch() {
        return this.match;
    }

    public String getClazz() {
        return this.clazz;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String serializeAsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<mailet match=\"").append(this.getMatch()).append("\" class=\"").append(this.getClazz()).append("\">\n");
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            builder.append("<").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">\n");
        }
        builder.append("</mailet>\n");
        return builder.toString();
    }

    public static class Builder {
        private String match;
        private String clazz;
        private ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

        private Builder() {
        }

        public Builder match(String match) {
            this.match = match;
            return this;
        }

        public Builder clazz(String clazz) {
            this.clazz = clazz;
            return this;
        }

        public Builder addProperty(String key, String value) {
            this.properties.put((Object)key, (Object)value);
            return this;
        }

        public MailetConfiguration build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.match) ? 1 : 0) != 0, (Object)"'match' is mandatory");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.clazz) ? 1 : 0) != 0, (Object)"'class' is mandatory");
            return new MailetConfiguration(this.match, this.clazz, this.properties.build());
        }
    }
}

