/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets;

import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.james.GuiceJamesServer;
import org.apache.james.MemoryJamesServerMain;
import org.apache.james.mailets.TemporaryFilesystemModule;
import org.apache.james.mailets.configuration.MailetContainer;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.utils.GuiceProbe;
import org.junit.rules.TemporaryFolder;

public class TemporaryJamesServer {
    private static final String MAILETCONTAINER_CONFIGURATION_FILENAME = "mailetcontainer.xml";
    private static final int LIMIT_TO_3_MESSAGES = 3;
    private final GuiceJamesServer jamesServer;

    public TemporaryJamesServer(TemporaryFolder temporaryFolder, MailetContainer mailetContainer, Module ... additionalModules) throws Exception {
        this.appendMailetConfigurations(temporaryFolder, mailetContainer);
        this.jamesServer = new GuiceJamesServer().combineWith(new Module[]{MemoryJamesServerMain.inMemoryServerModule}).overrideWith(new Module[]{binder -> binder.bind(PersistenceAdapter.class).to(MemoryPersistenceAdapter.class)}).overrideWith((Module[])ImmutableList.builder().addAll(Arrays.asList(additionalModules)).add((Object)new TestJMAPServerModule(3)).add((Object)new TemporaryFilesystemModule(temporaryFolder)).build().toArray((Object[])new Module[additionalModules.length + 2]));
        this.jamesServer.start();
    }

    private void appendMailetConfigurations(TemporaryFolder temporaryFolder, MailetContainer mailetContainer) throws ConfigurationException, IOException {
        try (FileOutputStream outputStream = this.createMailetConfigurationFile(temporaryFolder);){
            IOUtils.write((String)mailetContainer.serializeAsXml(), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
        }
    }

    private FileOutputStream createMailetConfigurationFile(TemporaryFolder temporaryFolder) throws IOException {
        File configurationFolder = temporaryFolder.newFolder("conf");
        return new FileOutputStream(Paths.get(configurationFolder.getAbsolutePath(), MAILETCONTAINER_CONFIGURATION_FILENAME).toFile());
    }

    public void shutdown() {
        this.jamesServer.stop();
    }

    public <T extends GuiceProbe> T getProbe(Class<T> probe) {
        return (T)this.jamesServer.getProbe(probe);
    }
}

