/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.JamesServerResourceLoader;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.junit.rules.TemporaryFolder;

public class TemporaryFilesystemModule
extends AbstractModule {
    private static final List<String> CONFIGURATION_FILE_NAMES = ImmutableList.of((Object)"dnsservice.xml", (Object)"domainlist.xml", (Object)"imapserver.xml", (Object)"keystore", (Object)"lmtpserver.xml", (Object)"mailrepositorystore.xml", (Object)"managesieveserver.xml", (Object)"pop3server.xml", (Object)"recipientrewritetable.xml", (Object)"smtpserver.xml", (Object)"usersrepository.xml", (Object)"smime.p12", (Object[])new String[0]);
    private final Supplier<File> workingDirectory;

    private static File rootDir(TemporaryFolder temporaryFolder) {
        return temporaryFolder.getRoot();
    }

    public TemporaryFilesystemModule(TemporaryFolder temporaryFolder) {
        this(() -> TemporaryFilesystemModule.rootDir(temporaryFolder));
    }

    public TemporaryFilesystemModule(Supplier<File> workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    protected void configure() {
        try {
            this.bind(JamesDirectoriesProvider.class).toInstance((Object)new JamesServerResourceLoader(this.workingDirectory.get().getAbsolutePath()));
            this.copyResources(Paths.get(this.workingDirectory.get().getAbsolutePath(), "conf"));
            this.bindConstant().annotatedWith((Annotation)Names.named((String)"configurationPath")).to("file://conf/");
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void copyResources(Path resourcesFolder) throws FileNotFoundException, IOException {
        CONFIGURATION_FILE_NAMES.stream().forEach(resourceName -> this.copyResource(resourcesFolder, (String)resourceName));
    }

    private void copyResource(Path resourcesFolder, String resourceName) {
        try (FileOutputStream outputStream = new FileOutputStream(resourcesFolder.resolve(resourceName).toFile());){
            IOUtils.copy((InputStream)ClassLoader.getSystemClassLoader().getResource(resourceName).openStream(), (OutputStream)outputStream);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

