/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets;

import com.google.inject.Module;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionFactory;
import org.apache.james.mailets.TemporaryJamesServer;
import org.apache.james.mailets.configuration.CommonProcessors;
import org.apache.james.mailets.configuration.MailetContainer;
import org.apache.james.mailets.utils.SMTPMessageSender;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.IMAPMessageReader;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RecipientRewriteTableIntegrationTest {
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int IMAP_PORT = 1143;
    private static final int SMTP_PORT = 1025;
    private static final String PASSWORD = "secret";
    private static final String JAMES_APACHE_ORG = "james.org";
    private static final String FROM = "fromUser@james.org";
    private static final String RECIPIENT = "touser@james.org";
    private static final String ANY_AT_JAMES = "any@james.org";
    private static final String OTHER_AT_JAMES = "other@james.org";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private TemporaryJamesServer jamesServer;
    private ConditionFactory calmlyAwait;
    private DataProbe dataProbe;

    @Before
    public void setup() throws Exception {
        MailetContainer mailetContainer = MailetContainer.builder().postmaster("postmaster@james.org").threads(5).addProcessor(CommonProcessors.root()).addProcessor(CommonProcessors.error()).addProcessor(CommonProcessors.transport()).addProcessor(CommonProcessors.spam()).addProcessor(CommonProcessors.localAddressError()).addProcessor(CommonProcessors.relayDenied()).addProcessor(CommonProcessors.bounces()).addProcessor(CommonProcessors.sieveManagerCheck()).build();
        this.jamesServer = new TemporaryJamesServer(this.temporaryFolder, mailetContainer, new Module[0]);
        Duration slowPacedPollInterval = Duration.FIVE_HUNDRED_MILLISECONDS;
        this.calmlyAwait = Awaitility.with().pollInterval(slowPacedPollInterval).and().with().pollDelay(slowPacedPollInterval).await();
        this.dataProbe = (DataProbe)this.jamesServer.getProbe(DataProbeImpl.class);
        this.dataProbe.addDomain(JAMES_APACHE_ORG);
    }

    @After
    public void tearDown() {
        this.jamesServer.shutdown();
    }

    @Test
    public void rrtServiceShouldDeliverEmailToMappingRecipients() throws Exception {
        this.dataProbe.addUser(FROM, PASSWORD);
        this.createUserInbox(ANY_AT_JAMES);
        this.createUserInbox(OTHER_AT_JAMES);
        this.dataProbe.addAddressMapping("touser", JAMES_APACHE_ORG, ANY_AT_JAMES);
        this.dataProbe.addAddressMapping("touser", JAMES_APACHE_ORG, OTHER_AT_JAMES);
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage(FROM, RECIPIENT);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(ANY_AT_JAMES, PASSWORD));
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(OTHER_AT_JAMES, PASSWORD));
        }
    }

    @Test
    public void rrtServiceShouldNotDeliverEmailToRecipientWhenHaveMappingRecipients() throws Exception {
        this.dataProbe.addUser(FROM, PASSWORD);
        this.createUserInbox(RECIPIENT);
        this.createUserInbox(ANY_AT_JAMES);
        this.createUserInbox(OTHER_AT_JAMES);
        this.dataProbe.addAddressMapping("touser", JAMES_APACHE_ORG, ANY_AT_JAMES);
        this.dataProbe.addAddressMapping("touser", JAMES_APACHE_ORG, OTHER_AT_JAMES);
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage(FROM, RECIPIENT);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userDoesNotReceiveMessage(RECIPIENT, PASSWORD));
        }
    }

    @Test
    public void rrtServiceShouldDeliverEmailToRecipientOnLocalWhenMappingContainsNonDomain() throws Exception {
        String nonDomainUser = "nondomain";
        String localUser = nonDomainUser + "@" + this.dataProbe.getDefaultDomain();
        this.dataProbe.addUser(FROM, PASSWORD);
        this.createUserInbox(localUser);
        this.createUserInbox(OTHER_AT_JAMES);
        this.dataProbe.addAddressMapping("touser", JAMES_APACHE_ORG, nonDomainUser);
        this.dataProbe.addAddressMapping("touser", JAMES_APACHE_ORG, OTHER_AT_JAMES);
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, JAMES_APACHE_ORG);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage(FROM, RECIPIENT);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(OTHER_AT_JAMES, PASSWORD));
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(localUser, PASSWORD));
        }
    }

    private void createUserInbox(String username) throws Exception {
        this.dataProbe.addUser(username, PASSWORD);
        this.jamesServer.getProbe(MailboxProbeImpl.class).createMailbox("#private", username, "INBOX");
    }
}

