/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets;

import com.google.inject.Module;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import com.jayway.awaitility.core.ConditionFactory;
import org.apache.james.mailets.TemporaryJamesServer;
import org.apache.james.mailets.configuration.CommonProcessors;
import org.apache.james.mailets.configuration.MailetContainer;
import org.apache.james.mailets.utils.SMTPMessageSender;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.IMAPMessageReader;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CommonMailetConfigurationTest {
    private static final String DEFAULT_DOMAIN = "james.org";
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int IMAP_PORT = 1143;
    private static final int SMTP_PORT = 1025;
    private static final String PASSWORD = "secret";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private TemporaryJamesServer jamesServer;
    private ConditionFactory calmlyAwait;

    @Before
    public void setup() throws Exception {
        MailetContainer mailetContainer = MailetContainer.builder().postmaster("postmaster@james.org").threads(5).addProcessor(CommonProcessors.root()).addProcessor(CommonProcessors.error()).addProcessor(CommonProcessors.transport()).addProcessor(CommonProcessors.spam()).addProcessor(CommonProcessors.localAddressError()).addProcessor(CommonProcessors.relayDenied()).addProcessor(CommonProcessors.bounces()).addProcessor(CommonProcessors.sieveManagerCheck()).build();
        this.jamesServer = new TemporaryJamesServer(this.temporaryFolder, mailetContainer, new Module[0]);
        Duration slowPacedPollInterval = Duration.FIVE_HUNDRED_MILLISECONDS;
        this.calmlyAwait = Awaitility.with().pollInterval(slowPacedPollInterval).and().with().pollDelay(slowPacedPollInterval).await();
    }

    @After
    public void tearDown() {
        this.jamesServer.shutdown();
    }

    @Test
    public void startingJamesWithCommonMailetConfigurationShouldWork() throws Exception {
    }

    @Test
    public void simpleMailShouldBeSent() throws Exception {
        DataProbe dataProbe = (DataProbe)this.jamesServer.getProbe(DataProbeImpl.class);
        dataProbe.addDomain(DEFAULT_DOMAIN);
        String from = "user@james.org";
        dataProbe.addUser(from, PASSWORD);
        String recipient = "user2@james.org";
        dataProbe.addUser(recipient, PASSWORD);
        this.jamesServer.getProbe(MailboxProbeImpl.class).createMailbox("#private", recipient, "INBOX");
        try (SMTPMessageSender messageSender = SMTPMessageSender.noAuthentication(LOCALHOST_IP, 1025, DEFAULT_DOMAIN);
             IMAPMessageReader imapMessageReader = new IMAPMessageReader(LOCALHOST_IP, 1143);){
            messageSender.sendMessage(from, recipient);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(messageSender::messageHasBeenSent);
            this.calmlyAwait.atMost(Duration.ONE_MINUTE).until(() -> imapMessageReader.userReceivedMessage(recipient, PASSWORD));
        }
    }
}

