/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.common.collect.ImmutableSet;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.tika.TikaConfiguration;
import org.apache.james.modules.mailbox.TikaConfigurationReader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TikaConfigurationReaderTest {
    TikaConfigurationReaderTest() {
    }

    @Test
    void readTikaConfigurationShouldAcceptMandatoryValues() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.host=172.0.0.5\ntika.port=889\ntika.timeoutInMillis=500\n"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().host("172.0.0.5").port(889).timeoutInMillis(500).cacheDisabled().cacheWeightInBytes(0x6400000L).cacheEvictionPeriod(Duration.ofDays(1L)).build());
    }

    @Test
    void readTikaConfigurationShouldReturnDefaultOnMissingHost() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.port=889\ntika.timeoutInMillis=500\n"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().host("127.0.0.1").port(889).timeoutInMillis(500).build());
    }

    @Test
    void readTikaConfigurationShouldReturnDefaultOnMissingPort() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.host=172.0.0.5\ntika.timeoutInMillis=500\n"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().host("172.0.0.5").port(9998).timeoutInMillis(500).build());
    }

    @Test
    void readTikaConfigurationShouldReturnDefaultOnMissingTimeout() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.host=172.0.0.5\ntika.port=889\n"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().host("172.0.0.5").port(889).timeoutInMillis(30000).build());
    }

    @Test
    void tikaShouldBeDisabledByDefault() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader(""));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().disabled().build());
    }

    @Test
    void readTikaConfigurationShouldParseUnitForCacheEvictionPeriod() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.host=172.0.0.5\ntika.port=889\ntika.timeoutInMillis=500\ntika.cache.eviction.period=2H"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().host("172.0.0.5").port(889).timeoutInMillis(500).cacheEvictionPeriod(Duration.ofHours(2L)).build());
    }

    @Test
    void readTikaConfigurationShouldDefaultToSecondWhenMissingUnitForCacheEvitionPeriod() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.host=172.0.0.5\ntika.port=889\ntika.timeoutInMillis=500\ntika.cache.eviction.period=3600"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().host("172.0.0.5").port(889).timeoutInMillis(500).cacheEvictionPeriod(Duration.ofHours(1L)).build());
    }

    @Test
    void readTikaConfigurationShouldParseUnitForCacheWeightMax() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.host=172.0.0.5\ntika.port=889\ntika.timeoutInMillis=500\ntika.cache.weight.max=200M"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().host("172.0.0.5").port(889).timeoutInMillis(500).cacheWeightInBytes(0xC800000L).build());
    }

    @Test
    void readTikaConfigurationShouldDefaultToByteAsSizeUnit() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.host=172.0.0.5\ntika.port=889\ntika.timeoutInMillis=500\ntika.cache.weight.max=1520000"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().host("172.0.0.5").port(889).timeoutInMillis(500).cacheWeightInBytes(1520000L).build());
    }

    @Test
    void readTikaConfigurationShouldEnableCacheWhenConfigured() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.cache.enabled=true\ntika.host=172.0.0.5\ntika.port=889\ntika.timeoutInMillis=500\ntika.cache.weight.max=1520000"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().cacheEnabled().host("172.0.0.5").port(889).timeoutInMillis(500).cacheWeightInBytes(1520000L).build());
    }

    @Test
    void readTikaConfigurationShouldNotHaveContentTypeBlacklist() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.cache.enabled=true\ntika.host=172.0.0.5\ntika.port=889\ntika.timeoutInMillis=500\ntika.cache.weight.max=1520000"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().cacheEnabled().host("172.0.0.5").port(889).timeoutInMillis(500).cacheWeightInBytes(1520000L).contentTypeBlacklist((Set)ImmutableSet.of()).build());
    }

    @Test
    void readTikaConfigurationShouldHaveContentTypeBlacklist() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.cache.enabled=true\ntika.host=172.0.0.5\ntika.port=889\ntika.timeoutInMillis=500\ntika.cache.weight.max=1520000\ntika.contentType.blacklist=application/ics,application/zip"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().cacheEnabled().host("172.0.0.5").port(889).timeoutInMillis(500).cacheWeightInBytes(1520000L).contentTypeBlacklist((Set)ImmutableSet.of((Object)ContentType.MimeType.of((String)"application/ics"), (Object)ContentType.MimeType.of((String)"application/zip"))).build());
    }

    @Test
    void readTikaConfigurationShouldHaveContentTypeBlacklistWithWhiteSpace() throws Exception {
        PropertiesConfiguration configuration = this.newConfiguration();
        configuration.read((Reader)new StringReader("tika.enabled=true\ntika.cache.enabled=true\ntika.host=172.0.0.5\ntika.port=889\ntika.timeoutInMillis=500\ntika.cache.weight.max=1520000\ntika.contentType.blacklist=application/ics, application/zip"));
        Assertions.assertThat((Object)TikaConfigurationReader.readTikaConfiguration((Configuration)configuration)).isEqualTo((Object)TikaConfiguration.builder().enabled().cacheEnabled().host("172.0.0.5").port(889).timeoutInMillis(500).cacheWeightInBytes(1520000L).contentTypeBlacklist((Set)ImmutableSet.of((Object)ContentType.MimeType.of((String)"application/ics"), (Object)ContentType.MimeType.of((String)"application/zip"))).build());
    }

    private PropertiesConfiguration newConfiguration() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        return configuration;
    }
}

