/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.SearchConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SearchConfigurationTest {
    SearchConfigurationTest() {
    }

    @Test
    void unknownSearchImplementationShouldThrow() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"unknown");
        Assertions.assertThatThrownBy(() -> SearchConfiguration.from((Configuration)configuration)).isInstanceOf(ConfigurationException.class);
    }

    @Test
    void searchImplementationShouldReturnElasticSearchByDefault() throws Exception {
        Assertions.assertThat((Comparable)SearchConfiguration.from((Configuration)new PropertiesConfiguration()).getImplementation()).isEqualTo((Object)SearchConfiguration.Implementation.ElasticSearch);
    }

    @Test
    void searchImplementationShouldReturnElasticSearchWhenSetToElasticSearch() throws Exception {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"ElasticSearch");
        Assertions.assertThat((Comparable)SearchConfiguration.from((Configuration)configuration).getImplementation()).isEqualTo((Object)SearchConfiguration.Implementation.ElasticSearch);
    }

    @Test
    void searchImplementationShouldReturnElasticSearchWhenSetToElasticSearchWithAlternativeCase() throws Exception {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"elasticsearch");
        Assertions.assertThat((Comparable)SearchConfiguration.from((Configuration)configuration).getImplementation()).isEqualTo((Object)SearchConfiguration.Implementation.ElasticSearch);
    }

    @Test
    void searchImplementationShouldReturnScanningSearchWhenSetToScanningSearch() throws Exception {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"scanning");
        Assertions.assertThat((Comparable)SearchConfiguration.from((Configuration)configuration).getImplementation()).isEqualTo((Object)SearchConfiguration.Implementation.Scanning);
    }
}

