/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.tika.TikaConfiguration;
import org.apache.james.util.DurationParser;
import org.apache.james.util.Size;
import org.apache.james.util.StreamUtils;

public class TikaConfigurationReader {
    public static final String TIKA_ENABLED = "tika.enabled";
    public static final String TIKA_CACHE_ENABLED = "tika.cache.enabled";
    public static final String TIKA_HOST = "tika.host";
    public static final String TIKA_PORT = "tika.port";
    public static final String TIKA_TIMEOUT_IN_MS = "tika.timeoutInMillis";
    public static final String TIKA_CACHE_EVICTION_PERIOD = "tika.cache.eviction.period";
    public static final String TIKA_CACHE_WEIGHT_MAX = "tika.cache.weight.max";
    public static final String TIKA_CONTENT_TYPE_BLACKLIST = "tika.contentType.blacklist";

    public static TikaConfiguration readTikaConfiguration(Configuration configuration) {
        Optional<Boolean> enabled = Optional.ofNullable(configuration.getBoolean(TIKA_ENABLED, null));
        Optional<Boolean> cacheEnabled = Optional.ofNullable(configuration.getBoolean(TIKA_CACHE_ENABLED, null));
        Optional<String> host = Optional.ofNullable(configuration.getString(TIKA_HOST, null));
        Optional<Integer> port = Optional.ofNullable(configuration.getInteger(TIKA_PORT, null));
        Optional<Integer> timeoutInMillis = Optional.ofNullable(configuration.getInteger(TIKA_TIMEOUT_IN_MS, null));
        Optional<Duration> cacheEvictionPeriod = Optional.ofNullable(configuration.getString(TIKA_CACHE_EVICTION_PERIOD, null)).map(rawString -> DurationParser.parse((String)rawString, (ChronoUnit)ChronoUnit.SECONDS));
        Optional<Long> cacheWeight = Optional.ofNullable(configuration.getString(TIKA_CACHE_WEIGHT_MAX, null)).map(Throwing.function(Size::parse)).map(Size::asBytes);
        Set contentTypeBlacklist = (Set)StreamUtils.ofNullable((Object[])configuration.getStringArray(TIKA_CONTENT_TYPE_BLACKLIST)).map(String::trim).map(ContentType.MimeType::of).collect(ImmutableSet.toImmutableSet());
        return TikaConfiguration.builder().enable(enabled).host(host).port(port).timeoutInMillis(timeoutInMillis).cacheEnable(cacheEnabled).cacheEvictionPeriod(cacheEvictionPeriod).cacheWeightInBytes(cacheWeight).contentTypeBlacklist(contentTypeBlacklist).build();
    }
}

