/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.es.v7.ElasticSearchConfiguration;
import org.apache.james.backends.es.v7.ElasticSearchIndexer;
import org.apache.james.backends.es.v7.IndexName;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.backends.es.v7.ReadAliasName;
import org.apache.james.backends.es.v7.RoutingKey;
import org.apache.james.backends.es.v7.WriteAliasName;
import org.apache.james.events.EventListener;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailbox.elasticsearch.v7.ElasticSearchMailboxConfiguration;
import org.apache.james.mailbox.elasticsearch.v7.IndexAttachments;
import org.apache.james.mailbox.elasticsearch.v7.MailboxIdRoutingKeyFactory;
import org.apache.james.mailbox.elasticsearch.v7.MailboxIndexCreationUtil;
import org.apache.james.mailbox.elasticsearch.v7.events.ElasticSearchListeningMessageSearchIndex;
import org.apache.james.mailbox.elasticsearch.v7.query.QueryConverter;
import org.apache.james.mailbox.elasticsearch.v7.search.ElasticSearchSearcher;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.modules.mailbox.ElasticSearchQuotaSearcherModule;
import org.apache.james.modules.mailbox.ElasticSearchStartUpCheck;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchMailboxModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchMailboxModule.class);
    public static final String ELASTICSEARCH_CONFIGURATION_NAME = "elasticsearch";

    protected void configure() {
        this.install((Module)new ElasticSearchQuotaSearcherModule());
        this.bind(ElasticSearchListeningMessageSearchIndex.class).in(Scopes.SINGLETON);
        this.bind(MessageSearchIndex.class).to(ElasticSearchListeningMessageSearchIndex.class);
        this.bind(ListeningMessageSearchIndex.class).to(ElasticSearchListeningMessageSearchIndex.class);
        this.bind((TypeLiteral)new TypeLiteral<RoutingKey.Factory<MailboxId>>(){}).to(MailboxIdRoutingKeyFactory.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.GroupEventListener.class).addBinding().to(ElasticSearchListeningMessageSearchIndex.class);
        Multibinder.newSetBinder((Binder)this.binder(), StartUpCheck.class).addBinding().to(ElasticSearchStartUpCheck.class);
    }

    @Provides
    @Singleton
    @Named(value="mailbox")
    private ElasticSearchIndexer createMailboxElasticSearchIndexer(ReactorElasticSearchClient client, ElasticSearchMailboxConfiguration configuration) {
        return new ElasticSearchIndexer(client, configuration.getWriteAliasMailboxName());
    }

    @Provides
    @Singleton
    private ElasticSearchSearcher createMailboxElasticSearchSearcher(ReactorElasticSearchClient client, QueryConverter queryConverter, MailboxId.Factory mailboxIdFactory, MessageId.Factory messageIdFactory, ElasticSearchMailboxConfiguration configuration, RoutingKey.Factory<MailboxId> routingKeyFactory) {
        return new ElasticSearchSearcher(client, queryConverter, 100, mailboxIdFactory, messageIdFactory, configuration.getReadAliasMailboxName(), routingKeyFactory);
    }

    @Provides
    @Singleton
    private ElasticSearchConfiguration getElasticSearchConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration(ELASTICSEARCH_CONFIGURATION_NAME);
            return ElasticSearchConfiguration.fromProperties((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find elasticsearch configuration file. Using {}:{} as contact point", (Object)"127.0.0.1", (Object)9200);
            return ElasticSearchConfiguration.DEFAULT_CONFIGURATION;
        }
    }

    @Provides
    @Singleton
    private ElasticSearchMailboxConfiguration getElasticSearchMailboxConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration(ELASTICSEARCH_CONFIGURATION_NAME);
            return ElasticSearchMailboxConfiguration.fromProperties((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find elasticsearch configuration file. Providing a default ElasticSearchMailboxConfiguration");
            return ElasticSearchMailboxConfiguration.DEFAULT_CONFIGURATION;
        }
    }

    @Provides
    @Singleton
    public IndexAttachments provideIndexAttachments(ElasticSearchMailboxConfiguration configuration) {
        return configuration.getIndexAttachment();
    }

    @ProvidesIntoSet
    InitializationOperation createIndex(MailboxIndexCreator instance) {
        return InitilizationOperationBuilder.forClass(MailboxIndexCreator.class).init(instance::createIndex);
    }

    static class MailboxIndexCreator
    implements Startable {
        private final ElasticSearchConfiguration configuration;
        private final ElasticSearchMailboxConfiguration mailboxConfiguration;
        private final ReactorElasticSearchClient client;

        @Inject
        MailboxIndexCreator(ElasticSearchConfiguration configuration, ElasticSearchMailboxConfiguration mailboxConfiguration, ReactorElasticSearchClient client) {
            this.configuration = configuration;
            this.mailboxConfiguration = mailboxConfiguration;
            this.client = client;
        }

        void createIndex() throws IOException {
            MailboxIndexCreationUtil.prepareClient((ReactorElasticSearchClient)this.client, (ReadAliasName)this.mailboxConfiguration.getReadAliasMailboxName(), (WriteAliasName)this.mailboxConfiguration.getWriteAliasMailboxName(), (IndexName)this.mailboxConfiguration.getIndexMailboxName(), (ElasticSearchConfiguration)this.configuration);
        }
    }
}

