/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import java.util.List;
import org.apache.james.blob.aes.CryptoConfig;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.blobstore.BlobStoreModulesChooser;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class BlobStoreModulesChooserTest {
    BlobStoreModulesChooserTest() {
    }

    @Test
    void provideBlobStoreShouldReturnObjectStoreBlobStoreWhenObjectStoreConfigured() {
        ((ListAssert)Assertions.assertThat((List)BlobStoreModulesChooser.chooseModules((BlobStoreConfiguration)BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig())).filteredOn(module -> module instanceof BlobStoreModulesChooser.ObjectStorageBlobStoreDAODeclarationModule)).hasSize(1);
    }

    @Test
    void provideBlobStoreShouldReturnCassandraBlobStoreWhenCassandraConfigured() {
        ((ListAssert)Assertions.assertThat((List)BlobStoreModulesChooser.chooseModules((BlobStoreConfiguration)BlobStoreConfiguration.builder().cassandra().disableCache().passthrough().noCryptoConfig())).filteredOn(module -> module instanceof BlobStoreModulesChooser.CassandraBlobStoreDAODeclarationModule)).hasSize(1);
    }

    @Test
    void provideBlobStoreShouldReturnNoEncryptionWhenNoneConfigured() {
        ((ListAssert)Assertions.assertThat((List)BlobStoreModulesChooser.chooseModules((BlobStoreConfiguration)BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig())).filteredOn(module -> module instanceof BlobStoreModulesChooser.NoEncryptionModule)).hasSize(1);
    }

    @Test
    void provideBlobStoreShouldReturnEncryptionWhenConfigured() {
        ((ListAssert)Assertions.assertThat((List)BlobStoreModulesChooser.chooseModules((BlobStoreConfiguration)BlobStoreConfiguration.builder().cassandra().disableCache().passthrough().cryptoConfig(CryptoConfig.builder().password("myPass".toCharArray()).salt("73616c7479").build()))).filteredOn(module -> module instanceof BlobStoreModulesChooser.EncryptionModule)).hasSize(1);
    }
}

