/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import java.util.List;
import org.apache.james.modules.blobstore.BlobStoreCacheModulesChooser;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.mailbox.CassandraCacheSessionModule;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class BlobStoreCacheModulesChooserTest {
    BlobStoreCacheModulesChooserTest() {
    }

    @Test
    void chooseModulesShouldReturnCacheDisabledModuleWhenCacheDisabled() {
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)BlobStoreCacheModulesChooser.chooseModules((BlobStoreConfiguration)BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig())).hasSize(1)).first()).isInstanceOf(BlobStoreCacheModulesChooser.CacheDisabledModule.class);
    }

    @Test
    void chooseModulesShouldReturnCacheEnabledAndCassandraCacheModulesWhenCacheEnabled() {
        ((ListAssert)Assertions.assertThat((List)BlobStoreCacheModulesChooser.chooseModules((BlobStoreConfiguration)BlobStoreConfiguration.builder().s3().enableCache().deduplication().noCryptoConfig())).hasSize(2)).allSatisfy(module -> Assertions.assertThat((Object)module).isOfAnyClassIn(new Class[]{BlobStoreCacheModulesChooser.CacheEnabledModule.class, CassandraCacheSessionModule.class}));
    }
}

