/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore.validation;

import java.util.List;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.memory.InMemoryEventStore;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.blobstore.validation.RegisterStorageStrategyCommandHandler;
import org.apache.james.modules.blobstore.validation.StorageStrategyValidationEventSourcingSystem;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class StorageStrategyValidationEventSourcingSystemTest {
    private StorageStrategyValidationEventSourcingSystem testee;
    private InMemoryEventStore eventStore;

    @BeforeEach
    void setUp() {
        this.eventStore = new InMemoryEventStore();
        this.testee = new StorageStrategyValidationEventSourcingSystem((EventStore)this.eventStore);
    }

    @Test
    void startingForTheFirstTimeShouldSucceedWhenPassThrough() {
        StartUpCheck.CheckResult checkResult = this.testee.validate(BlobStoreConfiguration.builder().implementation(BlobStoreConfiguration.BlobStoreImplName.S3).disableCache().passthrough());
        Assertions.assertThat((Comparable)checkResult.getResultType()).isEqualTo((Object)StartUpCheck.ResultType.GOOD);
    }

    @Test
    void startingForTheFirstTimeShouldSucceedWhenDeduplication() {
        StartUpCheck.CheckResult checkResult = this.testee.validate(BlobStoreConfiguration.builder().implementation(BlobStoreConfiguration.BlobStoreImplName.S3).disableCache().deduplication());
        Assertions.assertThat((Comparable)checkResult.getResultType()).isEqualTo((Object)StartUpCheck.ResultType.GOOD);
    }

    @Test
    void startingShouldSucceedWhenTurningOnDeduplication() {
        this.testee.validate(BlobStoreConfiguration.builder().implementation(BlobStoreConfiguration.BlobStoreImplName.S3).disableCache().passthrough());
        StartUpCheck.CheckResult checkResult = this.testee.validate(BlobStoreConfiguration.builder().implementation(BlobStoreConfiguration.BlobStoreImplName.S3).disableCache().deduplication());
        Assertions.assertThat((Comparable)checkResult.getResultType()).isEqualTo((Object)StartUpCheck.ResultType.GOOD);
    }

    @Test
    void startingShouldFailWhenTurningOffDeduplication() {
        this.testee.validate(BlobStoreConfiguration.builder().implementation(BlobStoreConfiguration.BlobStoreImplName.S3).disableCache().deduplication());
        StartUpCheck.CheckResult checkResult = this.testee.validate(BlobStoreConfiguration.builder().implementation(BlobStoreConfiguration.BlobStoreImplName.S3).disableCache().passthrough());
        Assertions.assertThat((Comparable)checkResult.getResultType()).isEqualTo((Object)StartUpCheck.ResultType.BAD);
    }

    @Test
    void validatingSeveralTimeTheSameStrategyShouldNotAddEventsToTheHistory() {
        this.testee.validate(BlobStoreConfiguration.builder().implementation(BlobStoreConfiguration.BlobStoreImplName.S3).disableCache().deduplication());
        this.testee.validate(BlobStoreConfiguration.builder().implementation(BlobStoreConfiguration.BlobStoreImplName.S3).disableCache().deduplication());
        History history = (History)Mono.from((Publisher)this.eventStore.getEventsOfAggregate(RegisterStorageStrategyCommandHandler.AGGREGATE_ID)).block();
        Assertions.assertThat((List)history.getEventsJava()).hasSize(1);
    }
}

