/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.james.FakePropertiesProvider;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.server.blob.deduplication.StorageStrategy;
import org.apache.james.utils.PropertiesProvider;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BlobStoreConfigurationTest {
    private static final String S3 = "s3";
    private static final String CASSANDRA = "cassandra";

    BlobStoreConfigurationTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(BlobStoreConfiguration.class).verify();
    }

    @Test
    void provideChoosingConfigurationShouldThrowWhenMissingPropertyField() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"");
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("blob", (Configuration)configuration).build();
        Assertions.assertThatThrownBy(() -> BlobStoreConfiguration.parse((PropertiesProvider)propertyProvider)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void provideChoosingConfigurationShouldThrowWhenEmptyPropertyField() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"");
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("blob", (Configuration)configuration).build();
        Assertions.assertThatThrownBy(() -> BlobStoreConfiguration.parse((PropertiesProvider)propertyProvider)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void provideChoosingConfigurationShouldThrowWhenPropertyFieldIsNotInSupportedList() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"gabouzomeuh");
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("blob", (Configuration)configuration).build();
        Assertions.assertThatThrownBy(() -> BlobStoreConfiguration.parse((PropertiesProvider)propertyProvider)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void provideChoosingConfigurationShouldReturnCassandraWhenNoFile() throws Exception {
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("other_configuration_file", (Configuration)new PropertiesConfiguration()).build();
        Assertions.assertThat((Object)BlobStoreConfiguration.parse((PropertiesProvider)propertyProvider)).isEqualTo((Object)BlobStoreConfiguration.builder().cassandra().disableCache().passthrough());
    }

    @Test
    void provideChoosingConfigurationShouldReturnObjectStorageFactoryWhenConfigurationImplIsS3() throws Exception {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)BlobStoreConfiguration.BlobStoreImplName.S3.getName());
        configuration.addProperty("deduplication.enable", (Object)"true");
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("blob", (Configuration)configuration).build();
        Assertions.assertThat((Object)BlobStoreConfiguration.parse((PropertiesProvider)propertyProvider)).isEqualTo((Object)BlobStoreConfiguration.builder().s3().disableCache().deduplication());
    }

    @Test
    void provideChoosingConfigurationShouldReturnCassandraFactoryWhenConfigurationImplIsCassandra() throws Exception {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)BlobStoreConfiguration.BlobStoreImplName.CASSANDRA.getName());
        configuration.addProperty("deduplication.enable", (Object)"false");
        FakePropertiesProvider propertyProvider = FakePropertiesProvider.builder().register("blob", (Configuration)configuration).build();
        Assertions.assertThat((Object)BlobStoreConfiguration.parse((PropertiesProvider)propertyProvider)).isEqualTo((Object)BlobStoreConfiguration.builder().cassandra().disableCache().passthrough());
    }

    @Test
    void fromShouldThrowWhenBlobStoreImplIsMissing() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BlobStoreConfiguration.from((Configuration)configuration)).isInstanceOf(IllegalStateException.class)).hasMessage("implementation property is missing please use one of supported values in: cassandra, s3");
    }

    @Test
    void fromShouldThrowWhenBlobStoreImplIsNull() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BlobStoreConfiguration.from((Configuration)configuration)).isInstanceOf(IllegalStateException.class)).hasMessage("implementation property is missing please use one of supported values in: cassandra, s3");
    }

    @Test
    void fromShouldThrowWhenBlobStoreImplIsEmpty() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BlobStoreConfiguration.from((Configuration)configuration)).isInstanceOf(IllegalStateException.class)).hasMessage("implementation property is missing please use one of supported values in: cassandra, s3");
    }

    @Test
    void fromShouldThrowWhenBlobStoreImplIsNotInSupportedList() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"un_supported");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BlobStoreConfiguration.from((Configuration)configuration)).isInstanceOf(IllegalArgumentException.class)).hasMessage("un_supported is not a valid name of BlobStores, please use one of supported values in: cassandra, s3");
    }

    @Test
    void fromShouldReturnConfigurationWhenBlobStoreImplIsCassandra() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)CASSANDRA);
        configuration.addProperty("deduplication.enable", (Object)"false");
        Assertions.assertThat((String)BlobStoreConfiguration.from((Configuration)configuration).getImplementation().getName()).isEqualTo(CASSANDRA);
    }

    @Test
    void fromShouldReturnConfigurationWhenBlobStoreImplIsS3() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)S3);
        configuration.addProperty("deduplication.enable", (Object)"true");
        Assertions.assertThat((String)BlobStoreConfiguration.from((Configuration)configuration).getImplementation().getName()).isEqualTo(S3);
    }

    @Test
    void fromShouldReturnConfigurationWhenBlobStoreImplIsSupportedAndCaseInsensitive() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)"CAssAnDrA");
        configuration.addProperty("deduplication.enable", (Object)"true");
        Assertions.assertThat((String)BlobStoreConfiguration.from((Configuration)configuration).getImplementation().getName()).isEqualTo(CASSANDRA);
    }

    @Test
    void fromShouldReturnConfigurationWhenBlobStoreImplIsSupportedAndHasExtraSpaces() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)" cassandra ");
        configuration.addProperty("deduplication.enable", (Object)"false");
        Assertions.assertThat((String)BlobStoreConfiguration.from((Configuration)configuration).getImplementation().getName()).isEqualTo(CASSANDRA);
    }

    @Test
    void cacheEnabledShouldBeTrueWhenSpecified() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)BlobStoreConfiguration.BlobStoreImplName.S3.getName());
        configuration.addProperty("cache.enable", (Object)true);
        configuration.addProperty("deduplication.enable", (Object)"true");
        Assertions.assertThat((boolean)BlobStoreConfiguration.from((Configuration)configuration).cacheEnabled()).isTrue();
    }

    @Test
    void cacheEnabledShouldBeFalseWhenSpecified() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)BlobStoreConfiguration.BlobStoreImplName.S3.getName());
        configuration.addProperty("cache.enable", (Object)false);
        configuration.addProperty("deduplication.enable", (Object)"true");
        Assertions.assertThat((boolean)BlobStoreConfiguration.from((Configuration)configuration).cacheEnabled()).isFalse();
    }

    @Test
    void cacheEnabledShouldDefaultToFalse() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)BlobStoreConfiguration.BlobStoreImplName.S3.getName());
        configuration.addProperty("deduplication.enable", (Object)"true");
        Assertions.assertThat((boolean)BlobStoreConfiguration.from((Configuration)configuration).cacheEnabled()).isFalse();
    }

    @Test
    void storageStrategyShouldBePassthroughWhenDeduplicationDisabled() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)BlobStoreConfiguration.BlobStoreImplName.S3.getName());
        configuration.addProperty("deduplication.enable", (Object)"false");
        Assertions.assertThat((Comparable)BlobStoreConfiguration.from((Configuration)configuration).storageStrategy()).isEqualTo((Object)StorageStrategy.PASSTHROUGH);
    }

    @Test
    void storageStrategyShouldBeDeduplicationWhenDeduplicationEnabled() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)BlobStoreConfiguration.BlobStoreImplName.S3.getName());
        configuration.addProperty("deduplication.enable", (Object)"true");
        Assertions.assertThat((Comparable)BlobStoreConfiguration.from((Configuration)configuration).storageStrategy()).isEqualTo((Object)StorageStrategy.DEDUPLICATION);
    }

    @Test
    void buildingConfigurationShouldThrowWhenDeduplicationPropertieIsOmitted() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("implementation", (Object)BlobStoreConfiguration.BlobStoreImplName.S3.getName());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BlobStoreConfiguration.from((Configuration)configuration)).isInstanceOf(IllegalStateException.class)).hasMessage("deduplication.enable property is missing please use one of the supported values in: true, false\nIf you choose to enable deduplication, the mails with the same content will be stored only once.\nWarning: Once this feature is enabled, there is no turning back as turning it off will lead to the deletion of all\nthe mails sharing the same content once one is deleted.\nUpgrade note: If you are upgrading from James 3.5 or older, the deduplication was enabled.");
    }
}

