/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.filesystem.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.filesystem.api.FileSystem;

public class FileSystemFixture {
    public static final FileSystem THROWING_FILE_SYSTEM = new FileSystem(){

        public InputStream getResource(String url) throws IOException {
            throw new UnsupportedOperationException();
        }

        public File getFile(String fileURL) throws FileNotFoundException {
            throw new FileNotFoundException();
        }

        public File getBasedir() throws FileNotFoundException {
            throw new UnsupportedOperationException();
        }
    };
    public static final FileSystem CLASSPATH_FILE_SYSTEM = new FileSystem(){

        public InputStream getResource(String url) throws IOException {
            return ClassLoader.getSystemResourceAsStream(url);
        }

        public File getFile(String fileURL) throws FileNotFoundException {
            return new File(ClassLoader.getSystemResource("recursive/extensions-jars").getFile());
        }

        public File getBasedir() throws FileNotFoundException {
            throw new UnsupportedOperationException();
        }
    };
    public static final FileSystem RECURSIVE_CLASSPATH_FILE_SYSTEM = new FileSystem(){

        public InputStream getResource(String url) throws IOException {
            throw new UnsupportedOperationException();
        }

        public File getFile(String fileURL) throws FileNotFoundException {
            return new File(ClassLoader.getSystemResource("recursive/").getFile());
        }

        public File getBasedir() throws FileNotFoundException {
            throw new UnsupportedOperationException();
        }
    };
}

