/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.xml;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.MockDNSService;
import org.apache.james.domainlist.xml.XMLDomainList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDomainListTest
extends TestCase {
    private HierarchicalConfiguration setUpConfiguration(boolean auto, boolean autoIP, List<String> names) {
        DefaultConfigurationBuilder configuration = new DefaultConfigurationBuilder();
        configuration.addProperty("autodetect", (Object)auto);
        configuration.addProperty("autodetectIP", (Object)autoIP);
        for (int i = 0; i < names.size(); ++i) {
            configuration.addProperty("domainnames.domainname", (Object)names.get(i).toString());
        }
        return configuration;
    }

    private DNSService setUpDNSServer(final String hostName) {
        MockDNSService dns = new MockDNSService(){

            public String getHostName(InetAddress inet) {
                return hostName;
            }

            public InetAddress[] getAllByName(String name) throws UnknownHostException {
                return new InetAddress[]{InetAddress.getByName("127.0.0.1")};
            }

            public InetAddress getLocalHost() throws UnknownHostException {
                return InetAddress.getLocalHost();
            }
        };
        return dns;
    }

    public void testNoConfiguredDomains() throws Exception {
        ArrayList<String> domains = new ArrayList<String>();
        XMLDomainList dom = new XMLDomainList();
        dom.setLog((Log)new SimpleLog("MockLog"));
        dom.configure(this.setUpConfiguration(false, false, domains));
        dom.setDNSService(this.setUpDNSServer("localhost"));
        XMLDomainListTest.assertNull((String)"No domain found", (Object)dom.getDomains());
    }

    public void testGetDomains() throws Exception {
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("domain1.");
        domains.add("domain2.");
        XMLDomainList dom = new XMLDomainList();
        dom.setLog((Log)new SimpleLog("MockLog"));
        dom.configure(this.setUpConfiguration(false, false, domains));
        dom.setDNSService(this.setUpDNSServer("localhost"));
        XMLDomainListTest.assertTrue((String)"Two domain found", (dom.getDomains().length == 2 ? 1 : 0) != 0);
    }

    public void testGetDomainsAutoDetectNotLocalHost() throws Exception {
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("domain1.");
        XMLDomainList dom = new XMLDomainList();
        dom.setLog((Log)new SimpleLog("MockLog"));
        dom.configure(this.setUpConfiguration(true, false, domains));
        dom.setDNSService(this.setUpDNSServer("local"));
        XMLDomainListTest.assertEquals((String)"Two domains found", (int)dom.getDomains().length, (int)2);
    }

    public void testGetDomainsAutoDetectLocalHost() throws Exception {
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("domain1.");
        XMLDomainList dom = new XMLDomainList();
        dom.setLog((Log)new SimpleLog("MockLog"));
        dom.configure(this.setUpConfiguration(true, false, domains));
        dom.setDNSService(this.setUpDNSServer("localhost"));
        XMLDomainListTest.assertEquals((String)"One domain found", (int)dom.getDomains().length, (int)1);
    }
}

