/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.io.Reader;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;
import org.apache.james.GuiceJamesServer;
import org.apache.james.backends.cassandra.TestingSession;
import org.apache.james.backends.cassandra.init.SessionWithInitializedTablesFactory;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.protocols.Pop3GuiceProbe;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.pop3server.mailbox.CassandraPop3MetadataStore;
import org.apache.james.pop3server.mailbox.Pop3MetadataStore;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.SMTPMessageSender;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface Pop3ServerContract {
    public static final String USER = "bob@examplebis.local";
    public static final String PASSWORD = "123456";
    public static final String DOMAIN = "examplebis.local";

    @Test
    default public void mailsCanBeReadInPop3(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessage("bob@domain.tld", USER);
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listUniqueIdentifiers());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(1);
        Reader message = pop3Client.retrieveMessage(((POP3MessageInfo)pop3MessageInfos.get((int)0)).number);
        Assertions.assertThat((String)CharStreams.toString((Readable)message)).contains(new CharSequence[]{"subject: test\r\n\r\ncontent"});
        pop3Client.disconnect();
    }

    @Test
    default public void dandlingMetadataShouldBeCleanedUpForFollowingSessions(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        MailboxPath inbox = MailboxPath.inbox((Username)Username.of((String)USER));
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(inbox);
        ((POP3ViewProbe)server.getProbe(POP3ViewProbe.class)).insertDandlingMetadata(inbox);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listUniqueIdentifiers());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(1);
        Assertions.assertThat((Object)pop3Client.retrieveMessage(((POP3MessageInfo)pop3MessageInfos.get((int)0)).number)).isNull();
        POP3Client pop3Client2 = new POP3Client();
        pop3Client2.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client2.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos2 = ImmutableList.copyOf((Object[])pop3Client2.listUniqueIdentifiers());
        Assertions.assertThat((List)pop3MessageInfos2).isEmpty();
        pop3Client.disconnect();
        pop3Client2.disconnect();
    }

    @Test
    default public void manyMessagesCanBeRetrievedWithPOP3(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        IntStream.range(0, 50).forEach((IntConsumer)Throwing.intConsumer(i -> smtpMessageSender.sendMessage("bob@domain.tld", USER)));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 50L).size() == 50);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listUniqueIdentifiers());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(50);
        IntStream.range(0, 50).forEach((IntConsumer)Throwing.intConsumer(arg_0 -> Pop3ServerContract.lambda$manyMessagesCanBeRetrievedWithPOP3$3(pop3Client, (List)pop3MessageInfos, arg_0)));
        pop3Client.disconnect();
    }

    @Test
    default public void aMailWithAnAttachmentCanBeRetrieved(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        smtpMessageSender.sendMessageWithHeaders("bob@domain.tld", USER, ClassLoaderUtils.getSystemResourceAsString((String)"attachment.eml"));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listUniqueIdentifiers());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(1);
        Reader message = pop3Client.retrieveMessage(((POP3MessageInfo)pop3MessageInfos.get((int)0)).number);
        Assertions.assertThat((String)CharStreams.toString((Readable)message)).endsWith((CharSequence)ClassLoaderUtils.getSystemResourceAsString((String)"attachment.eml"));
        pop3Client.disconnect();
    }

    @Test
    default public void pop3SizeShouldMatch(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        smtpMessageSender.sendMessageWithHeaders("bob@domain.tld", USER, ClassLoaderUtils.getSystemResourceAsString((String)"attachment.eml"));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listMessages());
        Reader message = pop3Client.retrieveMessage(((POP3MessageInfo)pop3MessageInfos.get((int)0)).number);
        Assertions.assertThat((List)pop3MessageInfos).hasSize(1);
        Assertions.assertThat((int)((POP3MessageInfo)pop3MessageInfos.get((int)0)).size).isEqualTo(CharStreams.toString((Readable)message).length());
        pop3Client.disconnect();
    }

    @Test
    default public void mailReceivedDuringPOP3TransactionShouldBeIgnored(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        smtpMessageSender.sendMessageWithHeaders("bob@domain.tld", USER, ClassLoaderUtils.getSystemResourceAsString((String)"attachment.eml"));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listMessages());
        Assertions.assertThat((List)pop3MessageInfos).isEmpty();
        pop3Client.disconnect();
    }

    @Test
    default public void rsetShouldRefreshPOP3Session(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        smtpMessageSender.sendMessageWithHeaders("bob@domain.tld", USER, ClassLoaderUtils.getSystemResourceAsString((String)"attachment.eml"));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        pop3Client.reset();
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listMessages());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(1);
        pop3Client.disconnect();
    }

    @Test
    default public void rsetShouldCancelDeletes(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        smtpMessageSender.sendMessageWithHeaders("bob@domain.tld", USER, ClassLoaderUtils.getSystemResourceAsString((String)"attachment.eml"));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listMessages());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(1);
        pop3Client.deleteMessage(((POP3MessageInfo)pop3MessageInfos.get((int)0)).number);
        pop3Client.reset();
        Assertions.assertThat((List)ImmutableList.copyOf((Object[])pop3Client.listMessages())).hasSize(1);
        pop3Client.disconnect();
        pop3Client.disconnect();
    }

    @Test
    default public void deletesAreImmediateWithinASession(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        smtpMessageSender.sendMessageWithHeaders("bob@domain.tld", USER, ClassLoaderUtils.getSystemResourceAsString((String)"attachment.eml"));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listMessages());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(1);
        pop3Client.deleteMessage(((POP3MessageInfo)pop3MessageInfos.get((int)0)).number);
        Assertions.assertThat((List)ImmutableList.copyOf((Object[])pop3Client.listMessages())).isEmpty();
        pop3Client.disconnect();
    }

    @Test
    default public void pendingDeletesAreNotSeenByOtherSessions(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        smtpMessageSender.sendMessageWithHeaders("bob@domain.tld", USER, ClassLoaderUtils.getSystemResourceAsString((String)"attachment.eml"));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listMessages());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(1);
        pop3Client.deleteMessage(((POP3MessageInfo)pop3MessageInfos.get((int)0)).number);
        POP3Client pop3Client2 = new POP3Client();
        pop3Client2.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client2.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos2 = ImmutableList.copyOf((Object[])pop3Client2.listUniqueIdentifiers());
        Assertions.assertThat((List)pop3MessageInfos2).hasSize(1);
        pop3Client.disconnect();
        pop3Client2.disconnect();
    }

    @Test
    default public void disconnectsShouldNotPerformPendingDeletes(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        smtpMessageSender.sendMessageWithHeaders("bob@domain.tld", USER, ClassLoaderUtils.getSystemResourceAsString((String)"attachment.eml"));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listMessages());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(1);
        pop3Client.deleteMessage(((POP3MessageInfo)pop3MessageInfos.get((int)0)).number);
        pop3Client.disconnect();
        POP3Client pop3Client2 = new POP3Client();
        pop3Client2.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client2.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos2 = ImmutableList.copyOf((Object[])pop3Client2.listUniqueIdentifiers());
        Assertions.assertThat((List)pop3MessageInfos2).hasSize(1);
        pop3Client.disconnect();
    }

    @Test
    default public void linesStartingWithDotShouldBeWellHandled(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        String content = "subject: test\r\n\r\n.content\r\n";
        smtpMessageSender.sendMessageWithHeaders("bob@domain.tld", USER, content);
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listMessages());
        Reader message = pop3Client.retrieveMessage(((POP3MessageInfo)pop3MessageInfos.get((int)0)).number);
        Assertions.assertThat((String)CharStreams.toString((Readable)message)).endsWith((CharSequence)content);
        pop3Client.disconnect();
    }

    @Test
    default public void aBigMailCanBeRetrieved(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        smtpMessageSender.sendMessageWithHeaders("bob@domain.tld", USER, ClassLoaderUtils.getSystemResourceAsString((String)"big.eml"));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listUniqueIdentifiers());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(1);
        Reader message = pop3Client.retrieveMessage(((POP3MessageInfo)pop3MessageInfos.get((int)0)).number);
        Assertions.assertThat((String)CharStreams.toString((Readable)message)).endsWith((CharSequence)ClassLoaderUtils.getSystemResourceAsString((String)"big.eml"));
        pop3Client.disconnect();
    }

    @Test
    default public void aMailCanBeSentToManyRecipients(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        List<String> users = this.generateNUsers(10);
        users.forEach(user -> ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addUser(user, PASSWORD));
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        smtpMessageSender.sendMessageWithHeaders("bob@domain.tld", users, ClassLoaderUtils.getSystemResourceAsString((String)"attachment.eml"));
        users.forEach(user -> {
            Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), user, 1L).size() == 1);
            POP3Client pop3Client = new POP3Client();
            pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
            pop3Client.login(user, PASSWORD);
            ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listUniqueIdentifiers());
            Assertions.assertThat((List)pop3MessageInfos).hasSize(1);
            pop3Client.disconnect();
        });
    }

    private List<String> generateNUsers(int nbUsers) {
        return (List)IntStream.range(0, nbUsers).boxed().map(index -> "user" + index + "@examplebis.local").collect(ImmutableList.toImmutableList());
    }

    @Test
    default public void messageCanBeDeleted(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessage("bob@domain.tld", USER);
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        pop3Client.deleteMessage(pop3Client.listUniqueIdentifiers()[0].number);
        pop3Client.logout();
        POP3Client pop3Client2 = new POP3Client();
        pop3Client2.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client2.login(USER, PASSWORD);
        Assertions.assertThat((Object[])pop3Client2.listUniqueIdentifiers()).isEmpty();
        pop3Client2.disconnect();
    }

    @Test
    default public void manyMessagesCanBeDeletedWithPOP3(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        IntStream.range(0, 50).forEach((IntConsumer)Throwing.intConsumer(i -> smtpMessageSender.sendMessage("bob@domain.tld", USER)));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 50L).size() == 50);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listUniqueIdentifiers());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(50);
        pop3MessageInfos.forEach(Throwing.consumer(info -> pop3Client.deleteMessage(info.number)));
        pop3Client.logout();
        POP3Client pop3Client2 = new POP3Client();
        pop3Client2.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client2.login(USER, PASSWORD);
        Assertions.assertThat((Object[])pop3Client2.listUniqueIdentifiers()).isEmpty();
        pop3Client2.disconnect();
    }

    @Test
    default public void deletingAMessageDeletesOnlyOne(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        int mailCount = 50;
        IntStream.range(0, mailCount).forEach((IntConsumer)Throwing.intConsumer(i -> smtpMessageSender.sendMessage("bob@domain.tld", USER)));
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, (long)mailCount).size() == mailCount);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        ImmutableList pop3MessageInfos = ImmutableList.copyOf((Object[])pop3Client.listUniqueIdentifiers());
        Assertions.assertThat((List)pop3MessageInfos).hasSize(mailCount);
        pop3Client.deleteMessage(((POP3MessageInfo)pop3MessageInfos.get((int)45)).number);
        pop3Client.logout();
        POP3Client pop3Client2 = new POP3Client();
        pop3Client2.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client2.login(USER, PASSWORD);
        Assertions.assertThat((Object[])pop3Client2.listUniqueIdentifiers()).hasSize(49);
        pop3Client2.disconnect();
    }

    @Test
    default public void messagesShouldBeOrderedByReceivedDate(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
        SMTPMessageSender sender = smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort());
        sender.sendMessageWithHeaders("bob@domain.tld", USER, "Subject: Message 1\r\n\r\nBody 1");
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 1L).size() == 1);
        sender.sendMessageWithHeaders("bob@domain.tld", USER, "Subject: Message 2\r\n\r\nBody 2");
        Awaitility.await().until(() -> ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).searchMessage(MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.builder().build()).build(), USER, 2L).size() == 2);
        POP3Client pop3Client = new POP3Client();
        pop3Client.connect("127.0.0.1", ((Pop3GuiceProbe)server.getProbe(Pop3GuiceProbe.class)).getPop3Port());
        pop3Client.login(USER, PASSWORD);
        Object[] pop3MessageInfos = pop3Client.listUniqueIdentifiers();
        Assertions.assertThat((Object[])pop3MessageInfos).hasSize(2);
        Reader message1 = pop3Client.retrieveMessage(((POP3MessageInfo)pop3MessageInfos[0]).number);
        Assertions.assertThat((String)CharStreams.toString((Readable)message1)).contains(new CharSequence[]{"Subject: Message 1"});
        Reader message2 = pop3Client.retrieveMessage(((POP3MessageInfo)pop3MessageInfos[1]).number);
        Assertions.assertThat((String)CharStreams.toString((Readable)message2)).contains(new CharSequence[]{"Subject: Message 2"});
        pop3Client.disconnect();
    }

    private static /* synthetic */ void lambda$manyMessagesCanBeRetrievedWithPOP3$3(POP3Client pop3Client, List pop3MessageInfos, int i) throws Throwable {
        Reader message = pop3Client.retrieveMessage(((POP3MessageInfo)pop3MessageInfos.get((int)i)).number);
        Assertions.assertThat((String)CharStreams.toString((Readable)message)).contains(new CharSequence[]{"subject: test\r\n\r\ncontent"});
    }

    public static class POP3ViewProbeModule
    extends AbstractModule {
        protected void configure() {
            Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(POP3ViewProbe.class);
        }

        @Provides
        @Singleton
        TestingSession provideSession(SessionWithInitializedTablesFactory factory) {
            return new TestingSession(factory.get());
        }
    }

    public static class POP3ViewProbe
    implements GuiceProbe {
        private final CassandraPop3MetadataStore pop3MetadataStore;
        private final MailboxManager mailboxManager;
        private final MessageId.Factory messageIdFactory;

        @Inject
        private POP3ViewProbe(CassandraPop3MetadataStore pop3MetadataStore, MailboxManager mailboxManager, MessageId.Factory messageIdFactory) {
            this.pop3MetadataStore = pop3MetadataStore;
            this.mailboxManager = mailboxManager;
            this.messageIdFactory = messageIdFactory;
        }

        public void insertDandlingMetadata(MailboxPath mailboxPath) throws Exception {
            MailboxSession session = this.mailboxManager.createSystemSession(mailboxPath.getUser());
            MessageManager mailbox = this.mailboxManager.getMailbox(mailboxPath, session);
            Mono.from((Publisher)this.pop3MetadataStore.add(mailbox.getId(), new Pop3MetadataStore.StatMetadata(this.messageIdFactory.generate(), 128L))).block();
        }
    }
}

