/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import org.apache.james.DistributedPOP3JamesConfiguration;
import org.apache.james.ExtraProperties;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JamesServerMain;
import org.apache.james.SearchConfiguration;
import org.apache.james.SearchModuleChooser;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.json.DTO;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.NoACLMapper;
import org.apache.james.mailbox.RandomModSeqProvider;
import org.apache.james.mailbox.RandomUidProvider;
import org.apache.james.mailbox.cassandra.mail.ACLMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.NaiveThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.modules.BlobExportMechanismModule;
import org.apache.james.modules.CassandraConsistencyTaskSerializationModule;
import org.apache.james.modules.DistributedPop3Module;
import org.apache.james.modules.DistributedTaskManagerModule;
import org.apache.james.modules.DistributedTaskSerializationModule;
import org.apache.james.modules.MailboxModule;
import org.apache.james.modules.MailetProcessingModule;
import org.apache.james.modules.Pop3FixInconsistenciesWebAdminModule;
import org.apache.james.modules.blobstore.BlobStoreCacheModulesChooser;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.blobstore.BlobStoreModulesChooser;
import org.apache.james.modules.data.CassandraDomainListModule;
import org.apache.james.modules.data.CassandraJmapModule;
import org.apache.james.modules.data.CassandraRecipientRewriteTableModule;
import org.apache.james.modules.data.CassandraSieveRepositoryModule;
import org.apache.james.modules.data.CassandraUsersRepositoryModule;
import org.apache.james.modules.data.CassandraVacationModule;
import org.apache.james.modules.event.JMAPEventBusModule;
import org.apache.james.modules.event.RabbitMQEventBusModule;
import org.apache.james.modules.eventstore.CassandraEventStoreModule;
import org.apache.james.modules.mailbox.CassandraBlobStoreDependenciesModule;
import org.apache.james.modules.mailbox.CassandraDeletedMessageVaultModule;
import org.apache.james.modules.mailbox.CassandraMailboxModule;
import org.apache.james.modules.mailbox.CassandraSessionModule;
import org.apache.james.modules.mailbox.TikaMailboxModule;
import org.apache.james.modules.mailrepository.CassandraMailRepositoryModule;
import org.apache.james.modules.metrics.CassandraMetricsModule;
import org.apache.james.modules.protocols.JMAPServerModule;
import org.apache.james.modules.protocols.LMTPServerModule;
import org.apache.james.modules.protocols.ManageSieveServerModule;
import org.apache.james.modules.protocols.POP3ServerModule;
import org.apache.james.modules.protocols.ProtocolHandlerModule;
import org.apache.james.modules.protocols.SMTPServerModule;
import org.apache.james.modules.queue.rabbitmq.RabbitMQModule;
import org.apache.james.modules.server.DKIMMailetModule;
import org.apache.james.modules.server.DataRoutesModules;
import org.apache.james.modules.server.ElasticSearchMetricReporterModule;
import org.apache.james.modules.server.InconsistencyQuotasSolvingRoutesModule;
import org.apache.james.modules.server.JMXServerModule;
import org.apache.james.modules.server.MailQueueRoutesModule;
import org.apache.james.modules.server.MailRepositoriesRoutesModule;
import org.apache.james.modules.server.MailboxRoutesModule;
import org.apache.james.modules.server.MailboxesExportRoutesModule;
import org.apache.james.modules.server.MessagesRoutesModule;
import org.apache.james.modules.server.RabbitMailQueueRoutesModule;
import org.apache.james.modules.server.VacationRoutesModule;
import org.apache.james.modules.server.WebAdminMailOverWebModule;
import org.apache.james.modules.server.WebAdminReIndexingTaskSerializationModule;
import org.apache.james.modules.server.WebAdminServerModule;
import org.apache.james.modules.vault.DeletedMessageVaultRoutesModule;
import org.apache.james.modules.webadmin.CassandraRoutesModule;
import org.apache.james.modules.webadmin.InconsistencySolvingRoutesModule;
import org.apache.james.server.core.configuration.Configuration;

public class DistributedPOP3JamesServerMain
implements JamesServerMain {
    public static final Module WEBADMIN = Modules.combine((Module[])new Module[]{new CassandraRoutesModule(), new DataRoutesModules(), new VacationRoutesModule(), new DeletedMessageVaultRoutesModule(), new InconsistencyQuotasSolvingRoutesModule(), new InconsistencySolvingRoutesModule(), new MailboxesExportRoutesModule(), new MailboxRoutesModule(), new MailQueueRoutesModule(), new MailRepositoriesRoutesModule(), new WebAdminServerModule(), new WebAdminReIndexingTaskSerializationModule(), new MessagesRoutesModule(), new Pop3FixInconsistenciesWebAdminModule(), new WebAdminMailOverWebModule()});
    public static final Module PROTOCOLS = Modules.combine((Module[])new Module[]{new LMTPServerModule(), new JMAPServerModule(), new JMAPEventBusModule(), new ManageSieveServerModule(), new POP3ServerModule(), new ProtocolHandlerModule(), new SMTPServerModule(), WEBADMIN});
    private static final Module BLOB_MODULE = new BlobExportMechanismModule();
    private static final Module CASSANDRA_EVENT_STORE_JSON_SERIALIZATION_DEFAULT_MODULE = binder -> binder.bind(new TypeLiteral<Set<DTOModule<?, ? extends DTO>>>(){}).annotatedWith((Annotation)Names.named((String)"EventNestedTypes")).toInstance((Object)ImmutableSet.of());
    public static final Module CASSANDRA_SERVER_CORE_MODULE = Modules.combine((Module[])new Module[]{new CassandraBlobStoreDependenciesModule(), new CassandraDomainListModule(), new CassandraEventStoreModule(), new CassandraDeletedMessageVaultModule(), new CassandraJmapModule(), new CassandraMailRepositoryModule(), new CassandraMetricsModule(), new CassandraRecipientRewriteTableModule(), new CassandraSessionModule(), new CassandraSieveRepositoryModule(), new CassandraVacationModule(), new ElasticSearchMetricReporterModule(), BLOB_MODULE, CASSANDRA_EVENT_STORE_JSON_SERIALIZATION_DEFAULT_MODULE});
    public static final Module CASSANDRA_MAILBOX_MODULE = Modules.combine((Module[])new Module[]{new CassandraConsistencyTaskSerializationModule(), new CassandraMailboxModule(), new MailboxModule(), new TikaMailboxModule()});
    public static final Module REQUIRE_TASK_MANAGER_MODULE = Modules.combine((Module[])new Module[]{new MailetProcessingModule(), CASSANDRA_SERVER_CORE_MODULE, CASSANDRA_MAILBOX_MODULE, PROTOCOLS, new DKIMMailetModule()});
    protected static final Module MODULES = Modules.override((Module[])new Module[]{REQUIRE_TASK_MANAGER_MODULE, new DistributedTaskManagerModule()}).with(new Module[]{new RabbitMQModule(), new RabbitMailQueueRoutesModule(), new RabbitMQEventBusModule(), new DistributedTaskSerializationModule()});

    public static void main(String[] args) throws Exception {
        ExtraProperties.initialize();
        DistributedPOP3JamesConfiguration configuration = DistributedPOP3JamesConfiguration.builder().useWorkingDirectoryEnvProperty().build();
        LOGGER.info("Loading configuration {}", (Object)configuration.toString());
        GuiceJamesServer server = DistributedPOP3JamesServerMain.createServer(configuration).combineWith(new Module[]{new JMXServerModule()});
        JamesServerMain.main((GuiceJamesServer)server);
    }

    public static GuiceJamesServer createServer(DistributedPOP3JamesConfiguration configuration) {
        BlobStoreConfiguration blobStoreConfiguration = configuration.blobStoreConfiguration();
        SearchConfiguration searchConfiguration = configuration.searchConfiguration();
        return GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{MODULES}).combineWith((Collection)BlobStoreModulesChooser.chooseModules((BlobStoreConfiguration)blobStoreConfiguration)).combineWith((Collection)BlobStoreCacheModulesChooser.chooseModules((BlobStoreConfiguration)blobStoreConfiguration)).combineWith((Collection)SearchModuleChooser.chooseModules((SearchConfiguration)searchConfiguration)).combineWith((Collection)new UsersRepositoryModuleChooser((Module)new CassandraUsersRepositoryModule()).chooseModules(configuration.getUsersRepositoryImplementation())).overrideWith(new Module[]{new DistributedPop3Module()}).overrideWith(new Module[]{binder -> binder.bind(ThreadIdGuessingAlgorithm.class).to(NaiveThreadIdGuessingAlgorithm.class)}).overrideWith(new Module[]{binder -> binder.bind(ACLMapper.class).to(NoACLMapper.class)}).overrideWith(new Module[]{binder -> {
            binder.bind(RandomUidProvider.class).in(Scopes.SINGLETON);
            binder.bind(UidProvider.class).to(RandomUidProvider.class);
            binder.bind(RandomModSeqProvider.class).in(Scopes.SINGLETON);
            binder.bind(ModSeqProvider.class).to(RandomModSeqProvider.class);
        }});
    }
}

