/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.memory;

import java.util.Arrays;
import java.util.List;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.lib.UsersRepositoryManagement;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class UsersRepositoryManagementTest {
    static final DomainList NO_DOMAIN_LIST = null;
    UsersRepository usersRepository;
    UsersRepositoryManagement userManagement;

    UsersRepositoryManagementTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.usersRepository = MemoryUsersRepository.withoutVirtualHosting((DomainList)NO_DOMAIN_LIST);
        this.userManagement = new UsersRepositoryManagement();
        this.userManagement.setUsersRepository(this.usersRepository);
    }

    @Test
    void testUserCount() throws Exception {
        ((AbstractLongAssert)Assertions.assertThat((long)this.userManagement.countUsers()).describedAs("no user yet", new Object[0])).isEqualTo(0L);
        this.usersRepository.addUser(Username.of((String)"testcount1"), "testCount");
        ((AbstractLongAssert)Assertions.assertThat((long)this.userManagement.countUsers()).describedAs("1 user", new Object[0])).isEqualTo(1L);
        this.usersRepository.addUser(Username.of((String)"testcount2"), "testCount");
        ((AbstractLongAssert)Assertions.assertThat((long)this.userManagement.countUsers()).describedAs("2 users", new Object[0])).isEqualTo(2L);
        this.usersRepository.removeUser(Username.of((String)"testcount1"));
        ((AbstractLongAssert)Assertions.assertThat((long)this.userManagement.countUsers()).describedAs("1 user", new Object[0])).isEqualTo(1L);
    }

    @Test
    void testAddUserAndVerify() throws Exception {
        this.usersRepository.addUser(Username.of((String)"testcount1"), "testCount");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.userManagement.verifyExists("testNotAdded")).describedAs("user not there", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.userManagement.verifyExists("testCount1")).describedAs("user is there", new Object[0])).isTrue();
        this.usersRepository.removeUser(Username.of((String)"testcount1"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.userManagement.verifyExists("testCount1")).describedAs("user not there", new Object[0])).isFalse();
    }

    @Test
    void testDelUser() throws Exception {
        this.usersRepository.addUser(Username.of((String)"testdel"), "test");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.userManagement.verifyExists("testNotDeletable")).describedAs("user not there", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.userManagement.verifyExists("testdel")).describedAs("user is there", new Object[0])).isTrue();
        this.usersRepository.removeUser(Username.of((String)"testdel"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.userManagement.verifyExists("testdel")).describedAs("user no longer there", new Object[0])).isFalse();
    }

    @Test
    void testListUsers() throws Exception {
        Username[] usersArray = new Username[]{Username.of((String)"ccc"), Username.of((String)"aaa"), Username.of((String)"dddd"), Username.of((String)"bbbbb")};
        List<Username> users = Arrays.asList(usersArray);
        for (Username user : users) {
            this.usersRepository.addUser(user, "test");
        }
        String[] userNames = this.userManagement.listAllUsers();
        ((AbstractIntegerAssert)Assertions.assertThat((int)userNames.length).describedAs("user count", new Object[0])).isEqualTo(users.size());
        for (String user : userNames) {
            if (users.contains(Username.of((String)user))) continue;
            Fail.fail((String)"user not listed");
        }
    }

    @Test
    void testSetPassword() throws Exception {
        this.userManagement.addUser("testpwduser", "pwd1");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.usersRepository.test(Username.of((String)"testpwduser"), "pwd1")).describedAs("initial password", new Object[0])).isTrue();
        this.userManagement.setPassword("testpwduser", "");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.usersRepository.test(Username.of((String)"testpwduser"), "")).describedAs("password changed to empty", new Object[0])).isTrue();
        this.userManagement.setPassword("testpwduser", "pwd2");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.usersRepository.test(Username.of((String)"testpwduser"), "pwd2")).describedAs("password not changed to pwd2", new Object[0])).isTrue();
        this.userManagement.setPassword("testpwduser", "pWD2");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.usersRepository.test(Username.of((String)"testpwduser"), "pwd2")).describedAs("password no longer pwd2", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.usersRepository.test(Username.of((String)"testpwduser"), "pWD2")).describedAs("password changed to pWD2", new Object[0])).isTrue();
    }
}

