/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.memory;

import org.apache.james.UserEntityValidator;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.RecipientRewriteTableContract;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;

class MemoryRecipientRewriteTableTest
implements RecipientRewriteTableContract {
    AbstractRecipientRewriteTable recipientRewriteTable;

    MemoryRecipientRewriteTableTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.setUp();
    }

    @AfterEach
    void teardown() throws Exception {
        this.tearDown();
    }

    public void createRecipientRewriteTable() throws Exception {
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        MemoryDomainList domainList = new MemoryDomainList(dnsService);
        domainList.configure(DomainListConfiguration.DEFAULT);
        this.recipientRewriteTable = new MemoryRecipientRewriteTable();
        this.recipientRewriteTable.setUsersRepository((UsersRepository)MemoryUsersRepository.withVirtualHosting((DomainList)domainList));
        this.recipientRewriteTable.setUserEntityValidator(UserEntityValidator.NOOP);
    }

    public AbstractRecipientRewriteTable virtualUserTable() {
        return this.recipientRewriteTable;
    }
}

