/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.AliasReverseResolverImpl;
import org.apache.james.rrt.lib.CanSendFromContract;
import org.apache.james.rrt.lib.CanSendFromImpl;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;

public class CanSendFromImplTest
implements CanSendFromContract {
    AbstractRecipientRewriteTable recipientRewriteTable;
    CanSendFrom canSendFrom;

    @BeforeEach
    void setup() throws Exception {
        this.recipientRewriteTable = new MemoryRecipientRewriteTable();
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        MemoryDomainList domainList = new MemoryDomainList(dnsService);
        domainList.configure(DomainListConfiguration.DEFAULT);
        domainList.addDomain(DOMAIN);
        domainList.addDomain(OTHER_DOMAIN);
        this.recipientRewriteTable.setDomainList((DomainList)domainList);
        this.recipientRewriteTable.setConfiguration(RecipientRewriteTableConfiguration.DEFAULT_ENABLED);
        this.recipientRewriteTable.setUsersRepository((UsersRepository)MemoryUsersRepository.withVirtualHosting((DomainList)domainList));
        this.recipientRewriteTable.setUserEntityValidator(UserEntityValidator.NOOP);
        AliasReverseResolverImpl aliasReverseResolver = new AliasReverseResolverImpl((RecipientRewriteTable)this.recipientRewriteTable);
        this.canSendFrom = new CanSendFromImpl((RecipientRewriteTable)this.recipientRewriteTable, (AliasReverseResolver)aliasReverseResolver);
    }

    public CanSendFrom canSendFrom() {
        return this.canSendFrom;
    }

    public void addAliasMapping(Username alias, Username user) throws Exception {
        this.recipientRewriteTable.addAliasMapping(MappingSource.fromUser((String)alias.getLocalPart(), (Domain)((Domain)alias.getDomainPart().get())), user.asString());
    }

    public void addDomainMapping(Domain alias, Domain domain, Mapping.Type mappingType) throws Exception {
        switch (mappingType) {
            case Domain: {
                this.recipientRewriteTable.addDomainMapping(MappingSource.fromDomain((Domain)alias), domain);
                break;
            }
            case DomainAlias: {
                this.recipientRewriteTable.addDomainAliasMapping(MappingSource.fromDomain((Domain)alias), domain);
                break;
            }
            default: {
                throw new NotImplementedException(mappingType + " is not supported");
            }
        }
    }

    public void addGroupMapping(String group, Username user) throws Exception {
        this.recipientRewriteTable.addGroupMapping(MappingSource.fromUser((Username)Username.of((String)group)), user.asString());
    }
}

