/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import org.apache.james.UserEntityValidator;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableConfiguration;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.AliasReverseResolverContract;
import org.apache.james.rrt.lib.AliasReverseResolverImpl;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;

public class AliasReverseResolverImplTest
implements AliasReverseResolverContract {
    AbstractRecipientRewriteTable recipientRewriteTable;
    AliasReverseResolverImpl aliasReverseResolver;

    @BeforeEach
    void setup() throws Exception {
        this.recipientRewriteTable = new MemoryRecipientRewriteTable();
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        MemoryDomainList domainList = new MemoryDomainList(dnsService);
        domainList.configure(DomainListConfiguration.DEFAULT);
        domainList.addDomain(DOMAIN);
        domainList.addDomain(OTHER_DOMAIN);
        this.recipientRewriteTable.setDomainList((DomainList)domainList);
        this.recipientRewriteTable.setUsersRepository((UsersRepository)MemoryUsersRepository.withVirtualHosting((DomainList)domainList));
        this.recipientRewriteTable.setUserEntityValidator(UserEntityValidator.NOOP);
        this.recipientRewriteTable.setConfiguration(RecipientRewriteTableConfiguration.DEFAULT_ENABLED);
        this.aliasReverseResolver = new AliasReverseResolverImpl((RecipientRewriteTable)this.recipientRewriteTable);
    }

    public AliasReverseResolver aliasReverseResolver() {
        return this.aliasReverseResolver;
    }

    public void addAliasMapping(Username alias, Username user) throws Exception {
        this.recipientRewriteTable.addAliasMapping(MappingSource.fromUser((String)alias.getLocalPart(), (Domain)((Domain)alias.getDomainPart().get())), user.asString());
    }

    public void addDomainAlias(Domain alias, Domain domain) throws Exception {
        this.recipientRewriteTable.addDomainAliasMapping(MappingSource.fromDomain((Domain)alias), domain);
    }

    public void addGroupMapping(String group, Username user) throws Exception {
        this.recipientRewriteTable.addGroupMapping(MappingSource.fromUser((Username)Username.of((String)group)), user.asString());
    }
}

