/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.user.api.JamesUsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.JamesUser;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.AbstractUsersRepository;
import org.apache.james.user.lib.model.DefaultJamesUser;

@Deprecated
public abstract class AbstractJamesUsersRepository
extends AbstractUsersRepository
implements JamesUsersRepository,
RecipientRewriteTable {
    protected boolean ignoreCase;
    protected boolean enableAliases;
    protected boolean enableForwarding;

    @Override
    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.setIgnoreCase(configuration.getBoolean("ignoreCase", false));
        this.setEnableAliases(configuration.getBoolean("enableAliases", false));
        this.setEnableForwarding(configuration.getBoolean("enableForwarding", false));
        super.configure(configuration);
    }

    protected abstract void doAddUser(User var1) throws UsersRepositoryException;

    protected abstract void doUpdateUser(User var1) throws UsersRepositoryException;

    @Override
    protected void doAddUser(String username, String password) throws UsersRepositoryException {
        DefaultJamesUser newbie = new DefaultJamesUser(username, "SHA");
        newbie.setPassword(password);
        this.doAddUser(newbie);
    }

    public void updateUser(User user) throws UsersRepositoryException {
        if (!this.contains(user.getUserName())) {
            throw new UsersRepositoryException("User " + user.getUserName() + " does not exist");
        }
        this.doUpdateUser(user);
    }

    public Mappings getMappings(String username, String domain) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        MappingsImpl.Builder mappingsBuilder = MappingsImpl.builder();
        try {
            User user = this.getUserByName(username);
            if (user instanceof JamesUser) {
                String alias;
                JamesUser jUser = (JamesUser)user;
                if (this.enableAliases && jUser.getAliasing() && (alias = jUser.getAlias()) != null) {
                    mappingsBuilder.add(alias + "@" + domain);
                }
                if (this.enableForwarding && jUser.getForwarding()) {
                    String forward;
                    if (jUser.getForwardingDestination() != null && (forward = jUser.getForwardingDestination().toString()) != null) {
                        mappingsBuilder.add(forward);
                    } else {
                        String errorBuffer = "Forwarding was enabled for " + username + " but no forwarding address was set for this account.";
                        this.getLogger().error(errorBuffer);
                    }
                }
            }
        }
        catch (UsersRepositoryException e) {
            throw new RecipientRewriteTableException("Unable to lookup forwards/aliases", (Throwable)e);
        }
        MappingsImpl mappings = mappingsBuilder.build();
        if (mappings.size() == 0) {
            return null;
        }
        return mappings;
    }

    public void setEnableAliases(boolean enableAliases) {
        this.enableAliases = enableAliases;
    }

    public void setEnableForwarding(boolean enableForwarding) {
        this.enableForwarding = enableForwarding;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public Map<String, Mappings> getAllMappings() throws RecipientRewriteTableException {
        HashMap<String, Mappings> mappings = new HashMap<String, Mappings>();
        if (this.enableAliases || this.enableForwarding) {
            try {
                Iterator users = this.list();
                while (users.hasNext()) {
                    String domain;
                    String username;
                    String user = (String)users.next();
                    int index = user.indexOf("@");
                    if (index != -1) {
                        username = user.substring(0, index);
                        domain = user.substring(index + 1, user.length());
                    } else {
                        username = user;
                        domain = "localhost";
                    }
                    try {
                        mappings.put(user, this.getMappings(username, domain));
                    }
                    catch (RecipientRewriteTable.ErrorMappingException errorMappingException) {}
                }
            }
            catch (UsersRepositoryException e) {
                throw new RecipientRewriteTableException("Unable to access forwards/aliases", (Throwable)e);
            }
        }
        return mappings;
    }

    public Mappings getUserDomainMappings(String user, String domain) throws RecipientRewriteTableException {
        return MappingsImpl.empty();
    }

    public void addRegexMapping(String user, String domain, String regex) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only RecipientRewriteTable");
    }

    public void removeRegexMapping(String user, String domain, String regex) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only RecipientRewriteTable");
    }

    public void addAddressMapping(String user, String domain, String address) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only RecipientRewriteTable");
    }

    public void removeAddressMapping(String user, String domain, String address) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only RecipientRewriteTable");
    }

    public void addErrorMapping(String user, String domain, String error) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only RecipientRewriteTable");
    }

    public void removeErrorMapping(String user, String domain, String error) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only RecipientRewriteTable");
    }

    public void addMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only RecipientRewriteTable");
    }

    public void removeMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only RecipientRewriteTable");
    }

    public void addAliasDomainMapping(String aliasDomain, String realDomain) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only RecipientRewriteTable");
    }

    public void removeAliasDomainMapping(String aliasDomain, String realDomain) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only RecipientRewriteTable");
    }
}

