/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.util.Map;
import javax.inject.Inject;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.RecipientRewriteTableManagementMBean;
import org.apache.james.rrt.lib.Mappings;

public class RecipientRewriteTableManagement
extends StandardMBean
implements RecipientRewriteTableManagementMBean {
    private RecipientRewriteTable rrt;

    protected RecipientRewriteTableManagement() throws NotCompliantMBeanException {
        super(RecipientRewriteTableManagementMBean.class);
    }

    @Inject
    public void setManageableRecipientRewriteTable(RecipientRewriteTable rrt) {
        this.rrt = rrt;
    }

    public void addRegexMapping(String user, String domain, String regex) throws Exception {
        try {
            this.rrt.addRegexMapping(user, domain, regex);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeRegexMapping(String user, String domain, String regex) throws Exception {
        try {
            this.rrt.removeRegexMapping(user, domain, regex);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void addAddressMapping(String user, String domain, String address) throws Exception {
        try {
            this.rrt.addAddressMapping(user, domain, address);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeAddressMapping(String user, String domain, String address) throws Exception {
        try {
            this.rrt.removeAddressMapping(user, domain, address);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void addErrorMapping(String user, String domain, String error) throws Exception {
        try {
            this.rrt.addErrorMapping(user, domain, error);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeErrorMapping(String user, String domain, String error) throws Exception {
        try {
            this.rrt.removeErrorMapping(user, domain, error);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void addDomainMapping(String domain, String targetDomain) throws Exception {
        try {
            this.rrt.addAliasDomainMapping(domain, targetDomain);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeDomainMapping(String domain, String targetDomain) throws Exception {
        try {
            this.rrt.removeAliasDomainMapping(domain, targetDomain);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public Mappings getUserDomainMappings(String user, String domain) throws Exception {
        try {
            return this.rrt.getUserDomainMappings(user, domain);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void addMapping(String user, String domain, String mapping) throws Exception {
        try {
            this.rrt.addMapping(user, domain, mapping);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeMapping(String user, String domain, String mapping) throws Exception {
        try {
            this.rrt.removeMapping(user, domain, mapping);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public Map<String, Mappings> getAllMappings() throws Exception {
        try {
            return this.rrt.getAllMappings();
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }
}

