/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingImpl;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.RecipientRewriteTableUtil;

public class MappingsImpl
implements Mappings,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<Mapping> mappings;

    public static MappingsImpl empty() {
        return MappingsImpl.builder().build();
    }

    public static MappingsImpl fromRawString(String raw) {
        return MappingsImpl.fromCollection(MappingsImpl.mappingToCollection(raw));
    }

    private static ArrayList<String> mappingToCollection(String rawMapping) {
        ArrayList<String> map = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(rawMapping, RecipientRewriteTableUtil.getSeparator(rawMapping));
        while (tokenizer.hasMoreTokens()) {
            String raw = tokenizer.nextToken().trim();
            map.add(raw);
        }
        return map;
    }

    public static MappingsImpl fromCollection(Collection<String> mappings) {
        Builder builder = MappingsImpl.builder();
        for (String mapping : mappings) {
            builder.add(mapping);
        }
        return builder.build();
    }

    public static MappingsImpl fromMappings(Iterable<Mapping> mappings) {
        Builder builder = MappingsImpl.builder();
        for (Mapping mapping : mappings) {
            builder.add(mapping);
        }
        return builder.build();
    }

    public static Builder from(Mappings from) {
        Builder builder = new Builder();
        builder.addAll(from);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    private MappingsImpl(Collection<Mapping> mappings) {
        this.mappings = ImmutableList.copyOf(mappings);
    }

    @Override
    public Iterable<String> asStrings() {
        return FluentIterable.from(this.mappings).transform((Function)new Function<Mapping, String>(){

            public String apply(Mapping input) {
                return input.asString();
            }
        });
    }

    @Override
    public boolean contains(String mapping) {
        return this.mappings.contains((Object)mapping);
    }

    @Override
    public int size() {
        return this.mappings.size();
    }

    @Override
    public Mappings remove(String mappingAsString) {
        MappingImpl mapping = MappingImpl.of(mappingAsString);
        if (this.mappings.contains((Object)mapping)) {
            ArrayList updatedMappings = Lists.newArrayList(this.mappings);
            updatedMappings.remove(mapping);
            return new MappingsImpl(updatedMappings);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    @Override
    public Iterator<Mapping> iterator() {
        return this.mappings.iterator();
    }

    @Override
    public String serialize() {
        return Joiner.on((char)';').join(this.asStrings());
    }

    private Predicate<Mapping> hasType(final Mapping.Type type) {
        return new Predicate<Mapping>(){

            public boolean apply(Mapping input) {
                return input.getType().equals((Object)type);
            }
        };
    }

    @Override
    public boolean contains(Mapping.Type type) {
        Preconditions.checkNotNull((Object)((Object)type));
        return FluentIterable.from(this.mappings).anyMatch(this.hasType(type));
    }

    @Override
    public Mappings select(Mapping.Type type) {
        Preconditions.checkNotNull((Object)((Object)type));
        return MappingsImpl.fromMappings((Iterable<Mapping>)FluentIterable.from(this.mappings).filter(this.hasType(type)));
    }

    @Override
    public Mappings exclude(Mapping.Type type) {
        Preconditions.checkNotNull((Object)((Object)type));
        return MappingsImpl.fromMappings((Iterable<Mapping>)FluentIterable.from(this.mappings).filter(Predicates.not(this.hasType(type))));
    }

    @Override
    public Mapping getError() {
        Mappings errors = this.select(Mapping.Type.Error);
        Preconditions.checkState((!errors.isEmpty() ? 1 : 0) != 0);
        return (Mapping)Iterables.getFirst((Iterable)errors, null);
    }

    @Override
    public Optional<Mappings> toOptional() {
        if (this.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)this);
    }

    @Override
    public Mappings union(Mappings mappings) {
        Preconditions.checkState((mappings != null ? 1 : 0) != 0, (Object)"mappings is mandatory");
        return MappingsImpl.from(this).addAll(mappings).build();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mappings});
    }

    public boolean equals(Object obj) {
        if (obj instanceof MappingsImpl) {
            MappingsImpl other = (MappingsImpl)obj;
            return Objects.equal(this.mappings, other.mappings);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("mappings", this.mappings).toString();
    }

    public static class Builder {
        private final ImmutableList.Builder<Mapping> mappings = ImmutableList.builder();

        private Builder() {
        }

        public Builder add(String mapping) {
            return this.add(MappingImpl.of(mapping));
        }

        public Builder add(Mapping mapping) {
            this.mappings.add((Object)mapping);
            return this;
        }

        public Builder addAll(Mappings mappings) {
            this.mappings.addAll((Iterable)mappings);
            return this;
        }

        public MappingsImpl build() {
            return new MappingsImpl((Collection)this.mappings.build());
        }
    }
}

