/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.james.rrt.lib.Mapping;

public class MappingImpl
implements Mapping,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ADDRESS_PREFIX = "";
    private final String mapping;

    public static MappingImpl of(String mapping) {
        return new MappingImpl(ADDRESS_PREFIX, mapping);
    }

    public static MappingImpl address(String mapping) {
        return new MappingImpl(ADDRESS_PREFIX, mapping);
    }

    public static MappingImpl regex(String mapping) {
        return new MappingImpl("regex:", mapping);
    }

    public static MappingImpl error(String mapping) {
        return new MappingImpl("error:", mapping);
    }

    public static MappingImpl domain(String mapping) {
        return new MappingImpl("domain:", mapping);
    }

    private MappingImpl(String prefix, String mapping) {
        Preconditions.checkNotNull((Object)mapping);
        this.mapping = prefix + mapping;
    }

    @Override
    public String asString() {
        return this.mapping;
    }

    @Override
    public boolean hasDomain() {
        return this.mapping.contains("@");
    }

    @Override
    public Mapping appendDomain(String domain) {
        Preconditions.checkNotNull((Object)domain);
        return new MappingImpl(ADDRESS_PREFIX, this.mapping + "@" + domain);
    }

    @Override
    public Mapping.Type getType() {
        if (this.mapping.startsWith("domain:")) {
            return Mapping.Type.Domain;
        }
        if (this.mapping.startsWith("regex:")) {
            return Mapping.Type.Regex;
        }
        if (this.mapping.startsWith("error:")) {
            return Mapping.Type.Error;
        }
        return Mapping.Type.Address;
    }

    @Override
    public String getErrorMessage() {
        Preconditions.checkState((boolean)this.mapping.startsWith("error:"));
        return this.mapping.substring("error:".length());
    }

    public boolean equals(Object other) {
        if (other instanceof MappingImpl) {
            MappingImpl otherMapping = (MappingImpl)other;
            return Objects.equal((Object)this.mapping, (Object)otherMapping.mapping);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mapping});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("mapping", (Object)this.mapping).toString();
    }
}

