/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.repository.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.repository.api.Repository;
import org.apache.james.repository.file.ExtensionFileFilter;
import org.apache.james.repository.file.NumberedRepositoryFileFilter;
import org.slf4j.Logger;

public abstract class AbstractFileRepository
implements Repository,
Configurable,
LogEnabled {
    protected static final boolean DEBUG = false;
    protected static final int BYTE_MASK = 15;
    protected static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected String m_extension;
    protected String m_name;
    protected FilenameFilter m_filter;
    protected File m_baseDirectory;
    private FileSystem fileSystem;
    private Logger logger;
    private String destination;

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.destination = configuration.getString("[@destinationURL]");
    }

    @Inject
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public void setLog(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected abstract String getExtensionDecorator();

    @PostConstruct
    public void init() throws Exception {
        File directory;
        this.getLogger().info("Init " + this.getClass().getName() + " Store");
        this.setDestination(this.destination);
        try {
            directory = this.m_baseDirectory.getCanonicalFile();
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Unable to form canonical representation of " + this.m_baseDirectory);
        }
        this.m_name = "Repository";
        String m_postfix = this.getExtensionDecorator();
        this.m_extension = "." + this.m_name + m_postfix;
        this.m_filter = new ExtensionFileFilter(this.m_extension);
        FileUtils.forceMkdir((File)directory);
        this.getLogger().info(this.getClass().getName() + " opened in " + this.m_baseDirectory);
        NumberedRepositoryFileFilter num_filter = new NumberedRepositoryFileFilter(this.getExtensionDecorator());
        String[] names = directory.list(num_filter);
        try {
            for (String origFilename : names) {
                for (int pos = origFilename.length() - m_postfix.length(); pos >= 1 && Character.isDigit(origFilename.charAt(pos - 1)); --pos) {
                }
                File origFile = new File(directory, origFilename);
                String newFilename = origFilename.substring(0, pos -= ".".length() + this.m_name.length()) + this.m_extension;
                File newFile = new File(directory, newFilename);
                if (origFile.renameTo(newFile)) {
                    this.getLogger().info("Renamed " + origFile + " to " + newFile);
                    continue;
                }
                this.getLogger().info("Unable to rename " + origFile + " to " + newFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void setDestination(String destination) throws ConfigurationException {
        if (!destination.startsWith("file://")) {
            throw new ConfigurationException("cannot handle destination " + destination);
        }
        try {
            this.m_baseDirectory = this.fileSystem.getFile(destination);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Unable to acces destination " + destination, (Throwable)e);
        }
    }

    protected AbstractFileRepository createChildRepository() throws Exception {
        return (AbstractFileRepository)this.getClass().newInstance();
    }

    @Override
    public Repository getChildRepository(String childName) {
        AbstractFileRepository child;
        try {
            child = this.createChildRepository();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create child repository " + childName + " : " + e);
        }
        child.setFileSystem(this.fileSystem);
        child.setLog(this.logger);
        try {
            child.setDestination(this.m_baseDirectory.getAbsolutePath() + File.pathSeparatorChar + childName + File.pathSeparator);
        }
        catch (ConfigurationException ce) {
            throw new RuntimeException("Cannot set destination for child child repository " + childName + " : " + (Object)((Object)ce));
        }
        try {
            child.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize child repository " + childName + " : " + e);
        }
        return child;
    }

    protected File getFile(String key) throws IOException {
        return new File(this.encode(key));
    }

    protected InputStream getInputStream(String key) throws IOException {
        return new FileInputStream(this.encode(key));
    }

    protected OutputStream getOutputStream(String key) throws IOException {
        return new FileOutputStream(this.getFile(key));
    }

    public synchronized boolean remove(String key) {
        try {
            FileUtils.forceDelete((File)this.getFile(key));
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while removing an object: " + e);
        }
    }

    public synchronized boolean containsKey(String key) {
        try {
            File file = this.getFile(key);
            return file.exists();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while searching an object: " + e);
        }
    }

    public Iterator<String> list() {
        File storeDir = new File(this.m_baseDirectory.getAbsolutePath());
        String[] names = storeDir.list(this.m_filter);
        ArrayList<String> list = new ArrayList<String>();
        for (String name : names) {
            String decoded = this.decode(name);
            list.add(decoded);
        }
        return list.iterator();
    }

    protected String encode(String key) {
        byte[] bytes = key.getBytes();
        char[] buffer = new char[bytes.length << 1];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte k = bytes[i];
            buffer[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buffer[j++] = HEX_DIGITS[k & 0xF];
        }
        StringBuilder result = new StringBuilder();
        result.append(this.m_baseDirectory.getAbsolutePath());
        result.append(File.separator);
        result.append(buffer);
        result.append(this.m_extension);
        return result.toString();
    }

    protected String decode(String filename) {
        filename = filename.substring(0, filename.length() - this.m_extension.length());
        int size = filename.length();
        byte[] bytes = new byte[size >>> 1];
        int i = 0;
        int j = 0;
        while (i < size) {
            bytes[j] = Byte.parseByte(filename.substring(i, i + 2), 16);
            i += 2;
            ++j;
        }
        return new String(bytes);
    }
}

