/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib.mock;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.AbstractJamesUsersRepository;
import org.apache.james.user.lib.model.DefaultJamesUser;
import org.apache.james.user.lib.model.DefaultUser;

public class MockUsersRepository
extends AbstractJamesUsersRepository {
    private final HashMap<String, User> m_users = new HashMap();
    private boolean m_forceUseJamesUser = false;

    public void setForceUseJamesUser() {
        this.m_forceUseJamesUser = true;
    }

    public User getUserByName(String name) throws UsersRepositoryException {
        if (this.ignoreCase) {
            return this.getUserByNameCaseInsensitive(name);
        }
        return this.m_users.get(name);
    }

    public User getUserByNameCaseInsensitive(String name) throws UsersRepositoryException {
        return this.m_users.get(name.toLowerCase(Locale.US));
    }

    public String getRealName(String name) throws UsersRepositoryException {
        if (this.ignoreCase) {
            return this.m_users.get(name.toLowerCase(Locale.US)) != null ? this.m_users.get(name.toLowerCase(Locale.US)).getUserName() : null;
        }
        return this.m_users.get(name) != null ? name : null;
    }

    public void removeUser(String name) throws UsersRepositoryException {
        if (!this.m_users.containsKey(name)) {
            throw new UsersRepositoryException("No such user");
        }
        this.m_users.remove(name);
    }

    public boolean contains(String name) throws UsersRepositoryException {
        if (this.ignoreCase) {
            return this.containsCaseInsensitive(name);
        }
        return this.m_users.containsKey(name);
    }

    public boolean containsCaseInsensitive(String name) {
        throw new UnsupportedOperationException("mock");
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        User user = this.getUserByName(name);
        if (user == null) {
            return false;
        }
        return user.verifyPassword(password);
    }

    public int countUsers() throws UsersRepositoryException {
        return this.m_users.size();
    }

    protected List<String> listUserNames() {
        Iterator<User> users = this.m_users.values().iterator();
        LinkedList<String> userNames = new LinkedList<String>();
        while (users.hasNext()) {
            User user = users.next();
            userNames.add(user.getUserName());
        }
        return userNames;
    }

    public Iterator<String> list() throws UsersRepositoryException {
        return this.listUserNames().iterator();
    }

    protected void doAddUser(User user) throws UsersRepositoryException {
        if (this.m_forceUseJamesUser && user instanceof DefaultUser) {
            DefaultUser aUser = (DefaultUser)user;
            user = new DefaultJamesUser(aUser.getUserName(), aUser.getHashedPassword(), aUser.getHashAlgorithm());
        }
        String key = user.getUserName();
        this.m_users.put(key, user);
    }

    protected void doUpdateUser(User user) throws UsersRepositoryException {
        if (!this.m_users.containsKey(user.getUserName())) {
            throw new UsersRepositoryException("No such user");
        }
        this.m_users.put(user.getUserName(), user);
    }
}

