/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.lib.UsersRepositoryManagement;
import org.apache.james.user.lib.mock.MockUsersRepository;

public class UsersRepositoryManagementTest
extends TestCase {
    private MockUsersRepository m_mockUsersRepository;
    private UsersRepositoryManagement m_userManagement;

    protected void setUp() throws Exception {
        this.m_mockUsersRepository = new MockUsersRepository();
        this.m_userManagement = new UsersRepositoryManagement();
        this.m_userManagement.setUsersRepository((UsersRepository)this.m_mockUsersRepository);
    }

    public void testUserCount() throws Exception {
        UsersRepositoryManagementTest.assertEquals((String)"no user yet", (long)0L, (long)this.m_userManagement.countUsers());
        this.m_mockUsersRepository.addUser("testCount1", "testCount");
        UsersRepositoryManagementTest.assertEquals((String)"1 user", (long)1L, (long)this.m_userManagement.countUsers());
        this.m_mockUsersRepository.addUser("testCount2", "testCount");
        UsersRepositoryManagementTest.assertEquals((String)"2 users", (long)2L, (long)this.m_userManagement.countUsers());
        this.m_mockUsersRepository.removeUser("testCount1");
        UsersRepositoryManagementTest.assertEquals((String)"1 user", (long)1L, (long)this.m_userManagement.countUsers());
    }

    public void testAddUserAndVerify() throws Exception {
        this.m_mockUsersRepository.addUser("testCount1", "testCount");
        UsersRepositoryManagementTest.assertFalse((String)"user not there", (boolean)this.m_userManagement.verifyExists("testNotAdded"));
        UsersRepositoryManagementTest.assertTrue((String)"user is there", (boolean)this.m_userManagement.verifyExists("testCount1"));
        this.m_mockUsersRepository.removeUser("testCount1");
        UsersRepositoryManagementTest.assertFalse((String)"user not there", (boolean)this.m_userManagement.verifyExists("testCount1"));
    }

    public void testDelUser() throws Exception {
        this.m_mockUsersRepository.addUser("testDel", "test");
        UsersRepositoryManagementTest.assertFalse((String)"user not there", (boolean)this.m_userManagement.verifyExists("testNotDeletable"));
        UsersRepositoryManagementTest.assertTrue((String)"user is there", (boolean)this.m_userManagement.verifyExists("testDel"));
        this.m_mockUsersRepository.removeUser("testDel");
        UsersRepositoryManagementTest.assertFalse((String)"user no longer there", (boolean)this.m_userManagement.verifyExists("testDel"));
    }

    public void testListUsers() throws Exception {
        String[] usersArray = new String[]{"ccc", "aaa", "dddd", "bbbbb"};
        List<String> users = Arrays.asList(usersArray);
        for (int i = 0; i < users.size(); ++i) {
            String user = users.get(i);
            this.m_mockUsersRepository.addUser(user, "test");
        }
        String[] userNames = this.m_userManagement.listAllUsers();
        UsersRepositoryManagementTest.assertEquals((String)"user count", (int)users.size(), (int)userNames.length);
        for (int i = 0; i < userNames.length; ++i) {
            String user = userNames[i];
            if (users.contains(user)) continue;
            UsersRepositoryManagementTest.fail((String)"user not listed");
        }
    }

    public void testSetPassword() throws Exception {
        this.m_userManagement.addUser("testPwdUser", "pwd1");
        UsersRepositoryManagementTest.assertTrue((String)"initial password", (boolean)this.m_mockUsersRepository.test("testPwdUser", "pwd1"));
        this.m_userManagement.setPassword("testPwdUser", "");
        UsersRepositoryManagementTest.assertTrue((String)"password changed to empty", (boolean)this.m_mockUsersRepository.test("testPwdUser", ""));
        this.m_userManagement.setPassword("testPwdUser", "pwd2");
        UsersRepositoryManagementTest.assertTrue((String)"password not changed to pwd2", (boolean)this.m_mockUsersRepository.test("testPwdUser", "pwd2"));
        this.m_userManagement.setPassword("testPwdUser", "pWD2");
        UsersRepositoryManagementTest.assertFalse((String)"password no longer pwd2", (boolean)this.m_mockUsersRepository.test("testPwdUser", "pwd2"));
        UsersRepositoryManagementTest.assertTrue((String)"password changed to pWD2", (boolean)this.m_mockUsersRepository.test("testPwdUser", "pWD2"));
    }
}

