/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;

public abstract class AbstractUsersRepositoryTest
extends TestCase {
    protected UsersRepository usersRepository;

    protected abstract UsersRepository getUsersRepository() throws Exception;

    public void testUsersRepositoryEmpty() throws UsersRepositoryException {
        AbstractUsersRepositoryTest.assertEquals((String)"users repository not empty", (int)0, (int)this.usersRepository.countUsers());
        AbstractUsersRepositoryTest.assertFalse((String)"users repository not empty", (boolean)this.usersRepository.list().hasNext());
    }

    public void testAddUserOnce() throws UsersRepositoryException {
        this.usersRepository.addUser("username", "password");
        try {
            this.usersRepository.addUser("username", "password2");
            AbstractUsersRepositoryTest.fail((String)"User added twice!");
        }
        catch (UsersRepositoryException e) {
            // empty catch block
        }
        try {
            this.usersRepository.addUser("username2", "password2");
            AbstractUsersRepositoryTest.assertTrue((boolean)this.usersRepository.contains("username2"));
            this.usersRepository.addUser("username3", "password3");
            AbstractUsersRepositoryTest.assertTrue((boolean)this.usersRepository.contains("username3"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUserAddedIsFound() throws UsersRepositoryException {
        this.usersRepository.addUser("username", "password");
        User user = this.usersRepository.getUserByName("username");
        AbstractUsersRepositoryTest.assertNotNull((Object)user);
        AbstractUsersRepositoryTest.assertEquals((String)"username does not match", (String)user.getUserName(), (String)"username");
        AbstractUsersRepositoryTest.assertTrue((String)"user not contained in the repository", (boolean)this.usersRepository.contains("username"));
        User u = this.usersRepository.getUserByName("uSERNAMe");
        AbstractUsersRepositoryTest.assertNull((String)"found the user searching for a different case!", (Object)u);
    }

    public void testUserListing() throws UsersRepositoryException {
        ArrayList<String> keys = new ArrayList<String>(3);
        keys.add("username1");
        keys.add("username2");
        keys.add("username3");
        for (String username : keys) {
            this.usersRepository.addUser(username, username);
        }
        AbstractUsersRepositoryTest.assertEquals((String)"Wrong number of users found", (int)keys.size(), (int)this.usersRepository.countUsers());
        ArrayList check = new ArrayList(keys);
        Iterator i = this.usersRepository.list();
        while (i.hasNext()) {
            String username = (String)i.next();
            if (this.getPasswordsEnabled()) {
                AbstractUsersRepositoryTest.assertTrue((boolean)this.usersRepository.test(username, username));
                User u = this.usersRepository.getUserByName(username);
                u.setPassword("newpass");
                this.usersRepository.updateUser(u);
            }
            AbstractUsersRepositoryTest.assertTrue((boolean)check.contains(username));
            check.remove(username);
        }
        AbstractUsersRepositoryTest.assertEquals((String)"Some user has not be found", (int)0, (int)check.size());
    }

    public void testUserPassword() throws UsersRepositoryException {
        this.usersRepository.addUser("username", "password");
        AbstractUsersRepositoryTest.assertEquals((String)"didn't accept the correct password ", (boolean)this.usersRepository.test("username", "password"), (boolean)this.getPasswordsEnabled());
        AbstractUsersRepositoryTest.assertFalse((String)"accepted the wrong password #1", (boolean)this.usersRepository.test("username", "password2"));
        AbstractUsersRepositoryTest.assertFalse((String)"accepted the wrong password #2", (boolean)this.usersRepository.test("username2", "password"));
        AbstractUsersRepositoryTest.assertFalse((String)"accepted the wrong password #3", (boolean)this.usersRepository.test("username", "Password"));
        AbstractUsersRepositoryTest.assertFalse((String)"accepted the wrong password #4", (boolean)this.usersRepository.test("username", "passwords"));
        AbstractUsersRepositoryTest.assertFalse((String)"accepted the wrong password #5", (boolean)this.usersRepository.test("userName", "password"));
    }

    protected boolean getPasswordsEnabled() {
        return true;
    }

    public void testUserAddRemoveCycle() throws UsersRepositoryException {
        AbstractUsersRepositoryTest.assertFalse((String)"accepted login when no user existed", (boolean)this.usersRepository.test("username", "password"));
        try {
            this.usersRepository.removeUser("username");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.usersRepository.addUser("username", "password");
        AbstractUsersRepositoryTest.assertEquals((String)"didn't accept the correct password", (boolean)this.usersRepository.test("username", "password"), (boolean)this.getPasswordsEnabled());
        User user = this.usersRepository.getUserByName("username");
        user.setPassword("newpass");
        try {
            this.usersRepository.updateUser(user);
            AbstractUsersRepositoryTest.assertEquals((String)"new password accepted", (boolean)this.usersRepository.test("username", "newpass"), (boolean)this.getPasswordsEnabled());
            AbstractUsersRepositoryTest.assertFalse((String)"old password rejected", (boolean)this.usersRepository.test("username", "password"));
        }
        catch (UnsupportedOperationException e) {
            AbstractUsersRepositoryTest.assertFalse((boolean)this.getPasswordsEnabled());
        }
        try {
            this.usersRepository.removeUser("username");
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractUsersRepositoryTest.fail((String)"removing the user failed!");
        }
        AbstractUsersRepositoryTest.assertFalse((String)"user not existing", (boolean)this.usersRepository.contains("username"));
        AbstractUsersRepositoryTest.assertFalse((String)"new password rejected", (boolean)this.usersRepository.test("username", "newpass"));
        try {
            this.usersRepository.updateUser(user);
            AbstractUsersRepositoryTest.fail();
        }
        catch (UsersRepositoryException usersRepositoryException) {
            // empty catch block
        }
    }

    protected boolean getCheckCase() {
        return true;
    }

    protected boolean getAllowMultipleUsersWithDifferentCases() {
        return this.getCheckCase();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.usersRepository = this.getUsersRepository();
    }

    protected void tearDown() throws Exception {
        this.disposeUsersRepository();
        super.tearDown();
    }

    protected void disposeUsersRepository() throws UsersRepositoryException {
        if (this.usersRepository != null) {
            LifecycleUtil.dispose((Object)this.usersRepository);
        }
    }
}

