/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.RecipientRewriteTableUtil;

public class MockRecipientRewriteTableManagementImpl
implements RecipientRewriteTable {
    HashMap store = new HashMap();

    public void addAddressMapping(String user, String domain, String address) throws RecipientRewriteTableException {
        this.addRawMapping(user, domain, address);
    }

    public void addErrorMapping(String user, String domain, String error) throws RecipientRewriteTableException {
        this.addRawMapping(user, domain, "error:" + error);
    }

    public void addMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        if (mapping.startsWith("error:")) {
            this.addErrorMapping(user, domain, mapping.substring("error:".length()));
        } else if (mapping.startsWith("regex:")) {
            this.addErrorMapping(user, domain, mapping.substring("regex:".length()));
        } else {
            this.addAddressMapping(user, domain, mapping);
        }
    }

    public void addRegexMapping(String user, String domain, String regex) throws RecipientRewriteTableException {
        this.addRawMapping(user, domain, "regex:" + regex);
    }

    public Map getAllMappings() throws RecipientRewriteTableException {
        if (this.store.size() > 0) {
            return this.store;
        }
        return null;
    }

    public Collection getUserDomainMappings(String user, String domain) throws RecipientRewriteTableException {
        String mapping = (String)this.store.get(user + "@" + domain);
        if (mapping != null) {
            return RecipientRewriteTableUtil.mappingToCollection((String)mapping);
        }
        return null;
    }

    public void removeAddressMapping(String user, String domain, String address) throws RecipientRewriteTableException {
        this.removeRawMapping(user, domain, address);
    }

    public void removeErrorMapping(String user, String domain, String error) throws RecipientRewriteTableException {
        this.removeRawMapping(user, domain, "error:" + error);
    }

    public void removeMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        if (mapping.startsWith("error:")) {
            this.removeErrorMapping(user, domain, mapping.substring("error:".length()));
        } else if (mapping.startsWith("regex:")) {
            this.removeErrorMapping(user, domain, mapping.substring("regex:".length()));
        } else {
            this.removeAddressMapping(user, domain, mapping);
        }
    }

    public void removeRegexMapping(String user, String domain, String regex) throws RecipientRewriteTableException {
        this.removeRawMapping(user, domain, "regex:" + regex);
    }

    public Collection<String> getMappings(String user, String domain) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private void addRawMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        String key = user + "@" + domain;
        String mappings = (String)this.store.get(key);
        if (mappings != null) {
            ArrayList map = RecipientRewriteTableUtil.mappingToCollection((String)mappings);
            if (map.contains(mapping)) {
                throw new RecipientRewriteTableException("Mapping " + mapping + " already exist!");
            }
            map.add(mapping);
            this.store.put(key, RecipientRewriteTableUtil.CollectionToMapping((Collection)map));
        } else {
            this.store.put(key, mapping);
        }
    }

    private void removeRawMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        ArrayList map;
        String key = user + "@" + domain;
        String mappings = (String)this.store.get(key);
        if (mappings != null && (map = RecipientRewriteTableUtil.mappingToCollection((String)mappings)).remove(mapping)) {
            this.store.put(key, RecipientRewriteTableUtil.CollectionToMapping((Collection)map));
        }
        throw new RecipientRewriteTableException("Mapping does not exist");
    }

    public void addAliasDomainMapping(String aliasDomain, String realDomain) throws RecipientRewriteTableException {
        this.addRawMapping(null, aliasDomain, "domain:" + realDomain);
    }

    public void removeAliasDomainMapping(String aliasDomain, String realDomain) throws RecipientRewriteTableException {
        this.removeRawMapping(null, aliasDomain, "domain:" + realDomain);
    }
}

