/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;

public abstract class AbstractRecipientRewriteTableTest
extends TestCase {
    protected AbstractRecipientRewriteTable virtualUserTable;
    protected static final int REGEX_TYPE = 0;
    protected static final int ERROR_TYPE = 1;
    protected static final int ADDRESS_TYPE = 2;
    protected static final int ALIASDOMAIN_TYPE = 3;

    protected void setUp() throws Exception {
        this.virtualUserTable = this.getRecipientRewriteTable();
    }

    protected void tearDown() throws Exception {
        Map mappings = this.virtualUserTable.getAllMappings();
        if (mappings != null) {
            Iterator mappingsIt = this.virtualUserTable.getAllMappings().keySet().iterator();
            while (mappingsIt.hasNext()) {
                String key = ((String)mappingsIt.next()).toString();
                String[] args = key.split("@");
                Collection map = (Collection)mappings.get(key);
                Iterator mapIt = map.iterator();
                while (mapIt.hasNext()) {
                    try {
                        this.removeMapping(args[0], args[1], ((String)mapIt.next()).toString());
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        LifecycleUtil.dispose((Object)this.virtualUserTable);
    }

    public void testStoreAndRetrieveRegexMapping() throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        String user = "test";
        String domain = "localhost";
        String regex = "(.*)@localhost";
        String regex2 = "(.+)@test";
        String invalidRegex = ".*):";
        boolean catched = false;
        try {
            AbstractRecipientRewriteTableTest.assertNull((String)"No mapping", (Object)this.virtualUserTable.getMappings(user, domain));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Added virtual mapping", (boolean)this.addMapping(user, domain, regex, 0));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Added virtual mapping", (boolean)this.addMapping(user, domain, regex2, 0));
            AbstractRecipientRewriteTableTest.assertEquals((String)"Two mappings", (int)this.virtualUserTable.getMappings(user, domain).size(), (int)2);
            AbstractRecipientRewriteTableTest.assertEquals((String)"One mappingline", (int)this.virtualUserTable.getAllMappings().size(), (int)1);
            AbstractRecipientRewriteTableTest.assertTrue((String)"remove virtual mapping", (boolean)this.removeMapping(user, domain, regex, 0));
            try {
                this.virtualUserTable.addRegexMapping(user, domain, invalidRegex);
            }
            catch (RecipientRewriteTableException e) {
                catched = true;
            }
            AbstractRecipientRewriteTableTest.assertTrue((String)"Invalid Mapping throw exception", (boolean)catched);
            AbstractRecipientRewriteTableTest.assertTrue((String)"remove virtual mapping", (boolean)this.removeMapping(user, domain, regex2, 0));
            AbstractRecipientRewriteTableTest.assertNull((String)"No mapping", (Object)this.virtualUserTable.getMappings(user, domain));
            AbstractRecipientRewriteTableTest.assertNull((String)"No mappings", (Object)this.virtualUserTable.getAllMappings());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            AbstractRecipientRewriteTableTest.fail((String)"Storing failed");
        }
    }

    public void testStoreAndRetrieveAddressMapping() throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        String user = "test";
        String domain = "localhost";
        String address = "test@localhost2";
        String address2 = "test@james";
        try {
            AbstractRecipientRewriteTableTest.assertNull((String)"No mapping", (Object)this.virtualUserTable.getMappings(user, domain));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Added virtual mapping", (boolean)this.addMapping(user, domain, address, 2));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Added virtual mapping", (boolean)this.addMapping(user, domain, address2, 2));
            AbstractRecipientRewriteTableTest.assertEquals((String)"Two mappings", (int)this.virtualUserTable.getMappings(user, domain).size(), (int)2);
            AbstractRecipientRewriteTableTest.assertEquals((String)"One mappingline", (int)this.virtualUserTable.getAllMappings().size(), (int)1);
            AbstractRecipientRewriteTableTest.assertTrue((String)"remove virtual mapping", (boolean)this.removeMapping(user, domain, address, 2));
            AbstractRecipientRewriteTableTest.assertTrue((String)"remove virtual mapping", (boolean)this.removeMapping(user, domain, address2, 2));
            AbstractRecipientRewriteTableTest.assertNull((String)"No mapping", (Object)this.virtualUserTable.getMappings(user, domain));
            AbstractRecipientRewriteTableTest.assertNull((String)"No mappings", (Object)this.virtualUserTable.getAllMappings());
        }
        catch (IllegalArgumentException e) {
            AbstractRecipientRewriteTableTest.fail((String)"Storing failed");
        }
    }

    public void testStoreAndRetrieveErrorMapping() throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        String user = "test";
        String domain = "localhost";
        String error = "bounce!";
        boolean catched = false;
        try {
            AbstractRecipientRewriteTableTest.assertNull((String)"No mapping", (Object)this.virtualUserTable.getMappings(user, domain));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Added virtual mapping", (boolean)this.addMapping(user, domain, error, 1));
            AbstractRecipientRewriteTableTest.assertEquals((String)"One mappingline", (int)this.virtualUserTable.getAllMappings().size(), (int)1);
            try {
                this.virtualUserTable.getMappings(user, domain);
            }
            catch (RecipientRewriteTable.ErrorMappingException e) {
                catched = true;
            }
            AbstractRecipientRewriteTableTest.assertTrue((String)"Error Mapping throw exception", (boolean)catched);
            AbstractRecipientRewriteTableTest.assertTrue((String)"remove virtual mapping", (boolean)this.removeMapping(user, domain, error, 1));
            AbstractRecipientRewriteTableTest.assertNull((String)"No mapping", (Object)this.virtualUserTable.getMappings(user, domain));
            AbstractRecipientRewriteTableTest.assertNull((String)"No mappings", (Object)this.virtualUserTable.getAllMappings());
        }
        catch (IllegalArgumentException e) {
            AbstractRecipientRewriteTableTest.fail((String)"Storing failed");
        }
    }

    public void testStoreAndRetrieveWildCardAddressMapping() throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        String user = "test";
        String user2 = "test2";
        String domain = "localhost";
        String address = "test@localhost2";
        String address2 = "test@james";
        try {
            AbstractRecipientRewriteTableTest.assertNull((String)"No mapping", (Object)this.virtualUserTable.getMappings(user, domain));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Added virtual mapping", (boolean)this.addMapping("*", domain, address, 2));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Added virtual mapping", (boolean)this.addMapping(user, domain, address2, 2));
            AbstractRecipientRewriteTableTest.assertTrue((String)"One mappings", (this.virtualUserTable.getMappings(user, domain).size() == 1 ? 1 : 0) != 0);
            AbstractRecipientRewriteTableTest.assertTrue((String)"One mappings", (this.virtualUserTable.getMappings(user2, domain).size() == 1 ? 1 : 0) != 0);
            AbstractRecipientRewriteTableTest.assertTrue((String)"remove virtual mapping", (boolean)this.removeMapping(user, domain, address2, 2));
            AbstractRecipientRewriteTableTest.assertTrue((String)"remove virtual mapping", (boolean)this.removeMapping("*", domain, address, 2));
            AbstractRecipientRewriteTableTest.assertNull((String)"No mapping", (Object)this.virtualUserTable.getMappings(user, domain));
            AbstractRecipientRewriteTableTest.assertNull((String)"No mapping", (Object)this.virtualUserTable.getMappings(user2, domain));
        }
        catch (IllegalArgumentException e) {
            AbstractRecipientRewriteTableTest.fail((String)"Storing failed");
        }
    }

    public void testRecursiveMapping() throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        String user1 = "user1";
        String user2 = "user2";
        String user3 = "user3";
        String domain1 = "domain1";
        String domain2 = "domain2";
        String domain3 = "domain3";
        boolean exception1 = false;
        this.virtualUserTable.setRecursiveMapping(true);
        try {
            AbstractRecipientRewriteTableTest.assertNull((String)"No mappings", (Object)this.virtualUserTable.getAllMappings());
            AbstractRecipientRewriteTableTest.assertTrue((String)"Add mapping", (boolean)this.addMapping(user1, domain1, user2 + "@" + domain2, 2));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Add mapping", (boolean)this.addMapping(user2, domain2, user3 + "@" + domain3, 2));
            AbstractRecipientRewriteTableTest.assertEquals((String)"Recursive mapped", (String)((String)this.virtualUserTable.getMappings(user1, domain1).iterator().next()), (String)(user3 + "@" + domain3));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Add mapping", (boolean)this.addMapping(user3, domain3, user1 + "@" + domain1, 2));
            try {
                this.virtualUserTable.getMappings(user1, domain1);
            }
            catch (RecipientRewriteTable.ErrorMappingException e) {
                exception1 = true;
            }
            AbstractRecipientRewriteTableTest.assertTrue((String)"Exception thrown on to many mappings", (boolean)exception1);
            this.virtualUserTable.setRecursiveMapping(false);
            AbstractRecipientRewriteTableTest.assertEquals((String)"Not recursive mapped", (String)((String)this.virtualUserTable.getMappings(user1, domain1).iterator().next()), (String)(user2 + "@" + domain2));
        }
        catch (IllegalArgumentException e) {
            AbstractRecipientRewriteTableTest.fail((String)"Storing failed");
        }
    }

    public void testAliasDomainMapping() throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        String domain = "realdomain";
        String aliasDomain = "aliasdomain";
        String user = "user";
        String user2 = "user2";
        AbstractRecipientRewriteTableTest.assertNull((String)"No mappings", (Object)this.virtualUserTable.getAllMappings());
        try {
            AbstractRecipientRewriteTableTest.assertTrue((String)"Add mapping", (boolean)this.addMapping("*", aliasDomain, user2 + "@" + domain, 2));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Add aliasDomain mapping", (boolean)this.addMapping("*", aliasDomain, domain, 3));
            Iterator mappings = this.virtualUserTable.getMappings(user, aliasDomain).iterator();
            AbstractRecipientRewriteTableTest.assertEquals((String)"Domain mapped as first ", (String)((String)mappings.next()), (String)(user + "@" + domain));
            AbstractRecipientRewriteTableTest.assertEquals((String)"Address mapped as second ", (String)((String)mappings.next()), (String)(user2 + "@" + domain));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Remove mapping", (boolean)this.removeMapping("*", aliasDomain, user2 + "@" + domain, 2));
            AbstractRecipientRewriteTableTest.assertTrue((String)"Remove aliasDomain mapping", (boolean)this.removeMapping("*", aliasDomain, domain, 3));
        }
        catch (IllegalArgumentException e) {
            AbstractRecipientRewriteTableTest.fail((String)"Storing failed");
        }
    }

    protected abstract AbstractRecipientRewriteTable getRecipientRewriteTable() throws Exception;

    protected abstract boolean addMapping(String var1, String var2, String var3, int var4) throws RecipientRewriteTableException;

    protected abstract boolean removeMapping(String var1, String var2, String var3, int var4) throws RecipientRewriteTableException;

    private void removeMapping(String user, String domain, String rawMapping) throws RecipientRewriteTableException {
        if (rawMapping.startsWith("error:")) {
            this.removeMapping(user, domain, rawMapping.substring("error:".length()), 1);
        } else if (rawMapping.startsWith("regex:")) {
            this.removeMapping(user, domain, rawMapping.substring("regex:".length()), 0);
        } else if (rawMapping.startsWith("domain:")) {
            this.removeMapping(user, domain, rawMapping.substring("domain:".length()), 3);
        } else {
            this.removeMapping(user, domain, rawMapping, 2);
        }
    }
}

