/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;
import junit.framework.TestCase;
import org.apache.james.core.MailImpl;
import org.apache.james.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.core.MimeMessageInputStreamSource;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public abstract class AbstractMailRepositoryTest
extends TestCase {
    String content = "Subject: test\r\nAAAContent-Transfer-Encoding: text/plain";
    String sep = "\r\n\r\n";
    String body = "original body\r\n.\r\n";
    protected Mail mail;
    protected MailRepository mailRepository;
    protected MimeMessage mimeMessage;

    protected void setUp() throws Exception {
        super.setUp();
        this.mailRepository = this.getMailRepository();
        MimeMessageInputStreamSource mmis = null;
        try {
            mmis = new MimeMessageInputStreamSource("test", (InputStream)new SharedByteArrayInputStream((this.content + this.sep + this.body).getBytes()));
        }
        catch (MessagingException e) {
            // empty catch block
        }
        this.mimeMessage = new MimeMessageCopyOnWriteProxy(mmis);
        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>();
        recipients.add(new MailAddress("rec1", "domain.com"));
        recipients.add(new MailAddress("rec2", "domain.com"));
        this.mail = new MailImpl("mail1", new MailAddress("sender", "domain.com"), recipients, this.mimeMessage);
        this.mail.setAttribute("testAttribute", (Serializable)((Object)"testValue"));
    }

    protected abstract MailRepository getMailRepository() throws Exception;

    protected void tearDown() throws Exception {
        Iterator i = this.mailRepository.list();
        while (i.hasNext()) {
            this.mailRepository.remove((String)i.next());
        }
        LifecycleUtil.dispose((Object)this.mail);
        LifecycleUtil.dispose((Object)this.mimeMessage);
        LifecycleUtil.dispose((Object)this.mailRepository);
        super.tearDown();
    }

    public void testStoreAndRetrieveMail() throws MessagingException, IOException {
        try {
            this.mailRepository.store(this.mail);
        }
        catch (Exception e) {
            AbstractMailRepositoryTest.fail((String)"Failed to store mail");
        }
        Mail m2 = this.mailRepository.retrieve((String)this.mailRepository.list().next());
        AbstractMailRepositoryTest.assertEquals((String)"stored and retrieved messages do not match", (String)this.mail.getMessage().getContent().toString(), (String)m2.getMessage().getContent().toString());
        AbstractMailRepositoryTest.assertEquals((String)"stored and retrieved message sizes do not match", (long)this.mail.getMessageSize(), (long)m2.getMessageSize());
        AbstractMailRepositoryTest.assertEquals((String)"stored and retrieved keys do not match", (String)this.mail.getName(), (String)m2.getName());
        AbstractMailRepositoryTest.assertEquals((String)"stored and retrieved states do not match", (String)this.mail.getState(), (String)m2.getState());
        AbstractMailRepositoryTest.assertEquals((String)"stored and retrieved attributes do not match", (Object)this.mail.getAttribute("testAttribute"), (Object)m2.getAttribute("testAttribute"));
        LifecycleUtil.dispose((Object)m2);
    }

    public void testEmptyRepository() throws MessagingException {
        AbstractMailRepositoryTest.assertFalse((boolean)this.mailRepository.list().hasNext());
        AbstractMailRepositoryTest.assertNull((Object)this.mailRepository.retrieve("random"));
        this.mailRepository.remove("random");
    }

    public void testListMail() throws MessagingException {
        this.mailRepository.store(this.mail);
        this.mailRepository.store(this.mail);
        Iterator i = this.mailRepository.list();
        AbstractMailRepositoryTest.assertTrue((boolean)i.hasNext());
        AbstractMailRepositoryTest.assertEquals((String)this.mail.getName(), (String)((String)i.next()));
        AbstractMailRepositoryTest.assertFalse((String)"Found more than one message after storing 2 times the SAME message: it MUST update the previous", (boolean)i.hasNext());
    }

    public void testJames559() throws Exception {
        this.mailRepository.store(this.mail);
        Mail m2 = this.mailRepository.retrieve("mail1");
        m2.getMessage().setHeader("X-Header", "foobar");
        m2.getMessage().saveChanges();
        this.mailRepository.store(m2);
        LifecycleUtil.dispose((Object)m2);
        m2 = this.mailRepository.retrieve("mail1");
        AbstractMailRepositoryTest.assertEquals((String)this.mail.getMessage().getContent().toString(), (String)m2.getMessage().getContent().toString());
        LifecycleUtil.dispose((Object)this.mail);
        this.mail = null;
        LifecycleUtil.dispose((Object)m2);
        this.mailRepository.remove("mail1");
    }

    public void testJames559WithoutSaveChanges() throws Exception {
        this.mailRepository.store(this.mail);
        Mail m2 = this.mailRepository.retrieve("mail1");
        m2.getMessage().setHeader("X-Header", "foobar");
        this.mailRepository.store(m2);
        LifecycleUtil.dispose((Object)m2);
        m2 = this.mailRepository.retrieve("mail1");
        AbstractMailRepositoryTest.assertEquals((String)this.mail.getMessage().getContent().toString(), (String)m2.getMessage().getContent().toString());
        LifecycleUtil.dispose((Object)this.mail);
        this.mail = null;
        LifecycleUtil.dispose((Object)m2);
        this.mailRepository.remove("mail1");
    }
}

