/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jpa;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.user.jpa.JPAUsersRepository;
import org.apache.james.user.jpa.model.JPAUser;
import org.apache.james.user.lib.AbstractUsersRepository;
import org.apache.james.user.lib.AbstractUsersRepositoryTest;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityTransaction;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.junit.After;
import org.junit.Before;
import org.slf4j.LoggerFactory;

public class JpaUsersRepositoryTest
extends AbstractUsersRepositoryTest {
    private HashMap<String, String> properties;
    private OpenJPAEntityManagerFactory factory;

    @Before
    public void setUp() throws Exception {
        this.properties = new HashMap();
        this.properties.put("openjpa.ConnectionDriverName", "org.h2.Driver");
        this.properties.put("openjpa.ConnectionURL", "jdbc:h2:target/users/db");
        this.properties.put("openjpa.Log", "JDBC=WARN, SQL=WARN, Runtime=WARN");
        this.properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72");
        this.properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        this.properties.put("openjpa.MetaDataFactory", "jpa(Types=" + JPAUser.class.getName() + ")");
        super.setUp();
        this.deleteAll();
    }

    @After
    public void tearDown() throws Exception {
        this.deleteAll();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAll() {
        OpenJPAEntityManager manager = this.factory.createEntityManager();
        OpenJPAEntityTransaction transaction = manager.getTransaction();
        try {
            transaction.begin();
            manager.createQuery("DELETE FROM JamesUser user").executeUpdate();
            transaction.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            manager.close();
        }
    }

    protected AbstractUsersRepository getUsersRepository() throws Exception {
        this.factory = OpenJPAPersistence.getEntityManagerFactory(this.properties);
        JPAUsersRepository repos = new JPAUsersRepository();
        repos.setLog(LoggerFactory.getLogger((String)"JPA"));
        repos.setEntityManagerFactory((EntityManagerFactory)this.factory);
        repos.configure((HierarchicalConfiguration)new DefaultConfigurationBuilder());
        return repos;
    }
}

